/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.compat.papi.expansion;

import gg.drak.thebase.objects.Identified;
import host.plas.bou.BetterPlugin;
import host.plas.bou.compat.papi.PAPIHolder;
import host.plas.bou.compat.papi.expansion.PlaceholderContext;
import java.util.function.Supplier;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BetterExpansion
extends PlaceholderExpansion
implements Identified {
    private BetterPlugin betterPlugin;
    private boolean persistent;
    private Supplier<String> identifierGetter;
    private Supplier<String> authorGetter;
    private Supplier<String> versionGetter;

    public BetterExpansion(BetterPlugin betterPlugin, Supplier<String> identifierGetter, Supplier<String> authorGetter, Supplier<String> versionGetter, boolean persistent, boolean register) {
        this.betterPlugin = betterPlugin;
        this.identifierGetter = identifierGetter;
        this.authorGetter = authorGetter;
        this.versionGetter = versionGetter;
        this.persistent = persistent;
        if (register) {
            this.register();
        }
    }

    public BetterExpansion(BetterPlugin betterPlugin, Supplier<String> identifierGetter, Supplier<String> authorGetter, Supplier<String> versionGetter, boolean persistentAndRegister) {
        this(betterPlugin, identifierGetter, authorGetter, versionGetter, persistentAndRegister, persistentAndRegister);
    }

    public BetterExpansion(BetterPlugin betterPlugin, Supplier<String> identifierGetter, Supplier<String> authorGetter, Supplier<String> versionGetter) {
        this(betterPlugin, identifierGetter, authorGetter, versionGetter, true);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, Supplier<String> authorGetter, Supplier<String> versionGetter, boolean persistent, boolean register) {
        this(betterPlugin, () -> identifier, authorGetter, versionGetter, persistent, register);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, Supplier<String> authorGetter, Supplier<String> versionGetter, boolean persistentAndRegister) {
        this(betterPlugin, identifier, authorGetter, versionGetter, persistentAndRegister, persistentAndRegister);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, Supplier<String> authorGetter, Supplier<String> versionGetter) {
        this(betterPlugin, identifier, authorGetter, versionGetter, true);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, String author, String version, boolean persistent, boolean register) {
        this(betterPlugin, () -> identifier, () -> author, () -> version, persistent, register);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, String author, String version, boolean persistentAndRegister) {
        this(betterPlugin, identifier, author, version, persistentAndRegister, persistentAndRegister);
    }

    public BetterExpansion(BetterPlugin betterPlugin, String identifier, String author, String version) {
        this(betterPlugin, identifier, author, version, true);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifierGetter.get();
    }

    @NotNull
    public String getVersion() {
        return this.versionGetter.get();
    }

    @NotNull
    public String getAuthor() {
        return this.authorGetter.get();
    }

    public boolean register() {
        this.load();
        return super.register();
    }

    public void load() {
        PAPIHolder.loadExpansion(this);
    }

    public void unload() {
        PAPIHolder.unloadExpansion(this);
    }

    public boolean persist() {
        return this.persistent;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        return this.onRequest((OfflinePlayer)player, params);
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        PlaceholderContext context = new PlaceholderContext(this, player, params);
        return this.replace(context);
    }

    @Nullable
    public abstract String replace(PlaceholderContext var1);

    @Override
    public int compareTo(@NotNull Identified o) {
        return Identified.super.compareTo(o);
    }

    public BetterPlugin getBetterPlugin() {
        return this.betterPlugin;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Supplier<String> getIdentifierGetter() {
        return this.identifierGetter;
    }

    public Supplier<String> getAuthorGetter() {
        return this.authorGetter;
    }

    public Supplier<String> getVersionGetter() {
        return this.versionGetter;
    }

    public void setBetterPlugin(BetterPlugin betterPlugin) {
        this.betterPlugin = betterPlugin;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setIdentifierGetter(Supplier<String> identifierGetter) {
        this.identifierGetter = identifierGetter;
    }

    public void setAuthorGetter(Supplier<String> authorGetter) {
        this.authorGetter = authorGetter;
    }

    public void setVersionGetter(Supplier<String> versionGetter) {
        this.versionGetter = versionGetter;
    }
}

