/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.configs.bits;

import gg.drak.thebase.objects.Identifiable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;

public class ConfigurableWhitelist<T extends Comparable<T>>
implements Identifiable {
    private String identifier;
    private ConcurrentSkipListSet<T> whitelist;
    private boolean blacklist;

    public ConfigurableWhitelist(String identifier) {
        this.identifier = identifier;
        this.whitelist = new ConcurrentSkipListSet();
        this.blacklist = false;
    }

    public boolean contains(T item) {
        return this.whitelist.contains(item) != this.blacklist;
    }

    public void add(T item) {
        this.whitelist.add(item);
    }

    public void remove(T item) {
        this.whitelist.remove(item);
    }

    public void removeIf(Predicate<T> predicate) {
        this.whitelist.removeIf(predicate);
    }

    public void clear() {
        this.whitelist.clear();
    }

    public boolean check(Predicate<T> predicate) {
        return this.whitelist.stream().anyMatch(predicate) && !this.blacklist;
    }

    public boolean checkAll(Predicate<T> predicate) {
        return this.whitelist.stream().allMatch(predicate) && !this.blacklist;
    }

    public boolean checkNone(Predicate<T> predicate) {
        return this.whitelist.stream().noneMatch(predicate) && !this.blacklist;
    }

    public boolean check(T item) {
        return this.whitelist.contains(item) && !this.blacklist || !this.whitelist.contains(item) && this.blacklist;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public ConcurrentSkipListSet<T> getWhitelist() {
        return this.whitelist;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setWhitelist(ConcurrentSkipListSet<T> whitelist) {
        this.whitelist = whitelist;
    }

    public void setBlacklist(boolean blacklist) {
        this.blacklist = blacklist;
    }
}

