/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.events.callbacks;

import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.events.BaseEventListener;
import gg.drak.thebase.events.components.BaseEvent;
import gg.drak.thebase.events.processing.BaseProcessor;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.events.callbacks.AbstractCallback;
import host.plas.bou.events.callbacks.BouCallback;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class CallbackManager {
    private static ConcurrentSkipListSet<BouCallback<?>> loadedCallbacks = new ConcurrentSkipListSet();
    private static AtomicInteger index = new AtomicInteger(0);
    private static CallbackListener callbackListener;

    public static void loadCallback(BouCallback<?> callback) {
        if (CallbackManager.hasCallback(callback.getIndex())) {
            CallbackManager.unloadCallback(callback.getIndex());
        }
        loadedCallbacks.add(callback);
    }

    public static void unloadCallback(int index) {
        loadedCallbacks.removeIf(c -> c.getIndex() == index);
    }

    public static boolean hasCallback(int index) {
        return CallbackManager.getCallback(index) != null;
    }

    public static BouCallback<?> getCallback(int index) {
        return loadedCallbacks.stream().filter(c -> c.getIndex() == index).findFirst().orElse(null);
    }

    public static <T, C extends BouCallback<T>> C getTypedCallback(int index) {
        return (C)CallbackManager.getCallback(index);
    }

    public static int getNextIndex() {
        return index.getAndIncrement();
    }

    public static <T> void subscribe(final Consumer<T> callback, Class<T> clazz) {
        new AbstractCallback<T>(callback, clazz){

            @Override
            public void accept(T t2) {
                callback.accept(t2);
            }
        };
    }

    public static void init() {
        callbackListener = new CallbackListener();
    }

    public static <E extends BaseEvent> void fireEvent(E event) {
        CallbackManager.getLoadedCallbacks().forEach(c -> {
            if (c.isOfType(event.getClass())) {
                AbstractCallback ac = (AbstractCallback)c;
                ac.accept(event);
            }
        });
    }

    public static ConcurrentSkipListSet<BouCallback<?>> getLoadedCallbacks() {
        return loadedCallbacks;
    }

    public static void setLoadedCallbacks(ConcurrentSkipListSet<BouCallback<?>> loadedCallbacks) {
        CallbackManager.loadedCallbacks = loadedCallbacks;
    }

    public static AtomicInteger getIndex() {
        return index;
    }

    public static void setIndex(AtomicInteger index) {
        CallbackManager.index = index;
    }

    public static CallbackListener getCallbackListener() {
        return callbackListener;
    }

    public static void setCallbackListener(CallbackListener callbackListener) {
        CallbackManager.callbackListener = callbackListener;
    }

    public static class CallbackListener
    implements BaseEventListener {
        public CallbackListener() {
            BaseEventHandler.bake(this, BukkitOfUtils.getInstance());
            BukkitOfUtils.getInstance().logInfo("&cCallback Listener &fhas been &aregistered&f!");
        }

        @BaseProcessor
        public <E extends BaseEvent> void onEvent(E event) {
            CallbackManager.fireEvent(event);
        }
    }
}

