/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.firestring;

import host.plas.bou.commands.Sender;
import host.plas.bou.firestring.FireStringConsumer;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.scheduling.TaskManager;
import host.plas.bou.utils.SenderUtils;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public enum BuiltIn {
    COMMAND_AS_CONSOLE("console", string -> Bukkit.dispatchCommand((CommandSender)SenderUtils.getConsoleSender(), (String)string)),
    COMMAND_AS_PLAYER("player", string -> {
        String[] split = string.split(" ", 2);
        String name = split[0];
        String command = split[1];
        Optional<Sender> sender = SenderUtils.getAsSender(name);
        sender.ifPresent(value -> value.executeCommand(command));
    }),
    CHAT_AS_CONSOLE("consolechat", string -> TaskManager.use(SenderUtils.getConsoleAsSender(), sender -> sender.chatAs((String)string))),
    CHAT_AS_PLAYER("playerchat", string -> {
        String[] split = string.split(" ", 2);
        String name = split[0];
        String message = split[1];
        Optional<Sender> sender = SenderUtils.getAsSender(name);
        sender.ifPresent(value -> value.chatAs(message));
    }),
    MESSAGE_PLAYER("message", string -> {
        String[] split = string.split(" ", 2);
        String name = split[0];
        String message = split[1];
        Optional<Sender> sender = SenderUtils.getAsSender(name);
        sender.ifPresent(value -> value.sendMessage(message));
    }),
    TITLE_PLAYER("title", string -> {
        String[] split = string.split(" ", 2);
        String name = split[0];
        String title = split[1];
        Optional<Sender> sender = SenderUtils.getAsSender(name);
        sender.ifPresent(value -> value.sendTitle(title));
    }),
    BROADCAST_MESSAGE("broadcast", string -> {
        Bukkit.getOnlinePlayers().forEach(player -> SenderUtils.getAsSender(player.getUniqueId().toString()).ifPresent(sender -> sender.sendMessage((String)string)));
        SenderUtils.getAsSender(BaseManager.getBaseConfig().getConsoleUUID()).ifPresent(sender -> sender.sendMessage((String)string));
    }),
    BROADCAST_TITLE("broadcasttitle", string -> Bukkit.getOnlinePlayers().forEach(player -> SenderUtils.getAsSender(player.getUniqueId().toString()).ifPresent(sender -> sender.sendTitle((String)string))));

    private final String identifier;
    private final FireStringConsumer consumer;

    private BuiltIn(String identifier, FireStringConsumer consumer) {
        this.identifier = identifier;
        this.consumer = consumer;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public FireStringConsumer getConsumer() {
        return this.consumer;
    }
}

