/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.firestring;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.objects.Identifiable;
import gg.drak.thebase.objects.SingleSet;
import gg.drak.thebase.utils.MatcherUtils;
import host.plas.bou.firestring.FireStringConsumer;
import host.plas.bou.firestring.FireStringManager;
import java.util.Iterator;
import java.util.List;

public class FireString
implements Identifiable {
    private String identifier;
    private FireStringConsumer consumer;

    public FireString(String identifier, FireStringConsumer consumer, boolean load) {
        this.identifier = identifier;
        this.consumer = consumer;
        if (load) {
            this.load();
        }
    }

    public void load() {
        FireStringManager.register(this);
    }

    public void unload() {
        FireStringManager.unregister(this.getIdentifier());
    }

    public void fire(String string) {
        this.consumer.accept(string);
    }

    public boolean checkAndFire(String string) {
        SingleSet<String, String> set = FireString.parse(string);
        if (set.getKey().equals(this.getIdentifier())) {
            this.fire(set.getValue());
            return true;
        }
        return false;
    }

    public static String getRegex() {
        return "[(](.*?)[)] (.*)";
    }

    public static SingleSet<String, String> parse(String string) {
        Matcher matcher = MatcherUtils.matcherBuilder(FireString.getRegex(), string);
        List<String[]> groups = MatcherUtils.getGroups(matcher, 2);
        if (groups.isEmpty()) {
            return new SingleSet<String, String>("", string);
        }
        Iterator<String[]> iterator = groups.iterator();
        if (iterator.hasNext()) {
            String[] group = iterator.next();
            return new SingleSet<String, String>(group[0], group[1]);
        }
        return new SingleSet<String, String>("", string);
    }

    public String toString() {
        return "FireString{identifier='" + this.identifier + "'}";
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public FireStringConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setConsumer(FireStringConsumer consumer) {
        this.consumer = consumer;
    }
}

