/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui;

import host.plas.bou.gui.slots.Slot;
import host.plas.bou.gui.slots.SlotType;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import mc.obliviate.inventory.Icon;
import org.bukkit.inventory.ItemStack;

public class InventorySheet {
    private int size;
    private ConcurrentSkipListSet<Slot> slots;

    public InventorySheet(int slots) {
        this.size = slots;
        this.slots = new ConcurrentSkipListSet();
    }

    public void addIcon(int slot, ItemStack stack, SlotType type) {
        this.slots.add(new Slot(slot, stack, type));
    }

    public void addIcon(int slot, Icon icon) {
        this.slots.add(new Slot(slot, icon, SlotType.OTHER));
    }

    public void removeIcon(int slot) {
        this.slots.removeIf(s2 -> s2.getIndex() == slot);
    }

    public Slot getSlot(int slot) {
        AtomicReference slotReference = new AtomicReference();
        this.slots.forEach(s2 -> {
            if (s2.getIndex() == slot) {
                slotReference.set(s2);
            }
        });
        return (Slot)slotReference.get();
    }

    public int getRows() {
        return (int)Math.ceil((double)this.size / 9.0);
    }

    public void forEachSlot(Consumer<Slot> consumer) {
        this.slots.forEach(consumer);
    }

    public int getSize() {
        return this.size;
    }

    public ConcurrentSkipListSet<Slot> getSlots() {
        return this.slots;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSlots(ConcurrentSkipListSet<Slot> slots) {
        this.slots = slots;
    }
}

