/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui;

import host.plas.bou.BukkitOfUtils;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MenuUtils {
    public static ConcurrentSkipListSet<Integer> getOuter(int rows) {
        ConcurrentSkipListSet<Integer> set = new ConcurrentSkipListSet<Integer>();
        if (rows < 1) {
            return set;
        }
        if (rows > 6) {
            rows = 6;
        }
        for (int r = 1; r <= rows; ++r) {
            for (int i2 = 1; i2 <= 9; ++i2) {
                int real = i2 * r - 1;
                if (real > 9 && real < 17 || real > 18 && real < 26 || real > 27 && real < 35 || real > 36 && real < 44 || real > 45 && real < 53) continue;
                set.add(real);
            }
        }
        return set;
    }

    public static NamespacedKey getInventoryKey(String string) {
        return new NamespacedKey((Plugin)BukkitOfUtils.getInstance(), "inventory-" + string);
    }

    public static NamespacedKey getStaticKey() {
        return MenuUtils.getInventoryKey("static");
    }

    public static NamespacedKey getButtonKey() {
        return MenuUtils.getInventoryKey("button");
    }

    public static void injectStatic(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(MenuUtils.getStaticKey(), PersistentDataType.INTEGER, (Object)1);
            stack.setItemMeta(meta);
        }
    }

    public static void injectButton(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(MenuUtils.getButtonKey(), PersistentDataType.INTEGER, (Object)1);
            stack.setItemMeta(meta);
        }
    }

    public static boolean isStatic(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(MenuUtils.getStaticKey(), PersistentDataType.INTEGER);
    }

    public static boolean isButton(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(MenuUtils.getButtonKey(), PersistentDataType.INTEGER);
    }
}

