/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui;

import host.plas.bou.gui.GuiMaintenanceListener;
import host.plas.bou.gui.screens.ScreenInstance;
import host.plas.bou.gui.screens.blocks.ScreenBlock;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ScreenManager {
    private static GuiMaintenanceListener guiMaintenanceListener;
    private static ConcurrentSkipListSet<ScreenInstance> screens;
    private static ConcurrentSkipListSet<ScreenBlock> loadedBlocks;

    public static void init() {
        guiMaintenanceListener = new GuiMaintenanceListener();
    }

    public static Optional<ScreenInstance> getScreen(Player player) {
        AtomicReference screen = new AtomicReference(Optional.empty());
        screens.forEach(s2 -> {
            if (s2.getIdentifier().equals(player.getUniqueId().toString())) {
                screen.set(Optional.of(s2));
            }
        });
        return screen.get();
    }

    public static Optional<ScreenInstance> getScreen(Inventory inventory) {
        AtomicReference screen = new AtomicReference(Optional.empty());
        screens.forEach(s2 -> {
            if (((Optional)screen.get()).isPresent()) {
                return;
            }
            if (s2.getInventory().equals(inventory)) {
                screen.set(Optional.of(s2));
            }
        });
        return screen.get();
    }

    public static void setScreen(Player player, ScreenInstance screen) {
        if (ScreenManager.hasScreen(player)) {
            ScreenManager.removeScreen(player);
        }
        screens.add(screen);
    }

    public static void removeScreen(Player player) {
        screens.removeIf(s2 -> s2.getIdentifier().equals(player.getUniqueId().toString()));
    }

    public static boolean hasScreen(Player player) {
        return ScreenManager.getScreen(player).isPresent();
    }

    public static ConcurrentSkipListSet<ScreenInstance> getPlayersOf(ScreenBlock block) {
        ConcurrentSkipListSet<ScreenInstance> players = new ConcurrentSkipListSet<ScreenInstance>();
        ScreenManager.getScreens().forEach(screenInstance -> screenInstance.getScreenBlock().ifPresent(screenBlock -> {
            if (screenBlock.equals(block)) {
                players.add((ScreenInstance)screenInstance);
            }
        }));
        return players;
    }

    public static void addBlock(ScreenBlock block) {
        loadedBlocks.add(block);
    }

    public static void removeBlock(Predicate<ScreenBlock> predicate) {
        loadedBlocks.removeIf(predicate);
    }

    public static Optional<ScreenBlock> getScreenBlock(ScreenInstance instance) {
        AtomicReference block = new AtomicReference(Optional.empty());
        loadedBlocks.forEach(b -> {
            if (((Optional)block.get()).isPresent()) {
                return;
            }
            if (instance.getScreenBlock().isPresent() && instance.getScreenBlock().get().equals(b)) {
                block.set(Optional.of(b));
            }
        });
        return block.get();
    }

    public static Optional<ScreenBlock> getScreenBlockOf(Player player) {
        AtomicReference block = new AtomicReference(Optional.empty());
        ScreenManager.getScreen(player).ifPresent(screen -> block.set(ScreenManager.getScreenBlock(screen)));
        return block.get();
    }

    public static boolean hasBlock(ScreenBlock block) {
        return loadedBlocks.contains(block);
    }

    public static GuiMaintenanceListener getGuiMaintenanceListener() {
        return guiMaintenanceListener;
    }

    public static void setGuiMaintenanceListener(GuiMaintenanceListener guiMaintenanceListener) {
        ScreenManager.guiMaintenanceListener = guiMaintenanceListener;
    }

    public static ConcurrentSkipListSet<ScreenInstance> getScreens() {
        return screens;
    }

    public static void setScreens(ConcurrentSkipListSet<ScreenInstance> screens) {
        ScreenManager.screens = screens;
    }

    public static ConcurrentSkipListSet<ScreenBlock> getLoadedBlocks() {
        return loadedBlocks;
    }

    public static void setLoadedBlocks(ConcurrentSkipListSet<ScreenBlock> loadedBlocks) {
        ScreenManager.loadedBlocks = loadedBlocks;
    }

    static {
        screens = new ConcurrentSkipListSet();
        loadedBlocks = new ConcurrentSkipListSet();
    }
}

