/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui.menus;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.gui.GuiType;
import host.plas.bou.gui.InventorySheet;
import host.plas.bou.gui.ScreenManager;
import host.plas.bou.gui.icons.BasicIcon;
import host.plas.bou.gui.menus.TaskMenu;
import host.plas.bou.gui.screens.ScreenInstance;
import host.plas.bou.items.ItemUtils;
import host.plas.bou.utils.obj.ManagedInventory;
import java.util.Optional;
import java.util.function.BiFunction;
import mc.obliviate.inventory.Icon;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PaginatedMenu
extends ScreenInstance {
    private ManagedInventory fullSlots;
    private int slotsPerPage;
    private int padLeft;
    private int padRight;
    private int padTop;
    private int padBottom;
    private BiFunction<Player, Integer, Icon> whenNotFilled;
    private BiFunction<Player, Integer, Icon> whenFilled;
    private int currentPage;

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int currentPage, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom, BiFunction<Player, Integer, Icon> whenNotFilled, BiFunction<Player, Integer, Icon> whenFilled) {
        super(player, type, PaginatedMenu.buildSheet(player, fullSlots, currentPage, slotsPerPage, padLeft, padRight, padTop, padBottom, whenNotFilled, whenFilled));
        this.fullSlots = fullSlots;
        this.slotsPerPage = slotsPerPage;
        this.padLeft = padLeft;
        this.padRight = padRight;
        this.padTop = padTop;
        this.padBottom = padBottom;
        this.whenNotFilled = whenNotFilled;
        this.whenFilled = whenFilled;
        this.currentPage = currentPage;
    }

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom, BiFunction<Player, Integer, Icon> whenNotFilled, BiFunction<Player, Integer, Icon> whenFilled) {
        this(player, type, fullSlots, 1, slotsPerPage, padLeft, padRight, padTop, padBottom, whenNotFilled, whenFilled);
    }

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int currentPage, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom, BiFunction<Player, Integer, Icon> whenNotFilled) {
        this(player, type, fullSlots, currentPage, slotsPerPage, padLeft, padRight, padTop, padBottom, whenNotFilled, (p, i2) -> null);
    }

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom, BiFunction<Player, Integer, Icon> whenNotFilled) {
        this(player, type, fullSlots, 1, slotsPerPage, padLeft, padRight, padTop, padBottom, whenNotFilled, (p, i2) -> null);
    }

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int currentPage, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom) {
        this(player, type, fullSlots, currentPage, slotsPerPage, padLeft, padRight, padTop, padBottom, (p, i2) -> null, (p, i2) -> null);
    }

    public PaginatedMenu(@NotNull Player player, GuiType type, ManagedInventory fullSlots, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom) {
        this(player, type, fullSlots, 1, slotsPerPage, padLeft, padRight, padTop, padBottom, (p, i2) -> null, (p, i2) -> null);
    }

    public static InventorySheet buildSheet(@NotNull Player player, ManagedInventory fullSlots, int page, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom, BiFunction<Player, Integer, Icon> whenNotFilled, BiFunction<Player, Integer, Icon> whenFilled) {
        InventorySheet sheet = new InventorySheet(54);
        try {
            int maxPages = PaginatedMenu.getMaxPages(fullSlots, slotsPerPage);
            if (page < 1) {
                page = 1;
            }
            if (page > maxPages) {
                page = maxPages;
            }
            for (int i2 = 0; i2 < sheet.getSize(); ++i2) {
                Icon basicIcon;
                try {
                    if (PaginatedMenu.isFillable(sheet, i2, slotsPerPage, padLeft, padRight, padTop, padBottom)) {
                        try {
                            int pageIndex = PaginatedMenu.getPageIndexOfSheetSlot(sheet, i2, slotsPerPage, padLeft, padRight, padTop, padBottom);
                            Icon icon = whenFilled.apply(player, pageIndex);
                            if (icon != null) {
                                sheet.addIcon(i2, icon);
                                continue;
                            }
                            ItemStack stack = fullSlots.getItem((page - 1) * slotsPerPage + pageIndex);
                            if (stack == null) continue;
                            BasicIcon basicIcon2 = new BasicIcon(stack);
                            sheet.addIcon(i2, basicIcon2);
                        }
                        catch (Throwable e) {
                            BukkitOfUtils.getInstance().logSevere("Error while building filled icon", e);
                            basicIcon = PaginatedMenu.buildPageIcon(i2);
                            sheet.addIcon(i2, basicIcon);
                        }
                        continue;
                    }
                    try {
                        Icon icon = whenNotFilled.apply(player, i2);
                        if (icon != null) {
                            sheet.addIcon(i2, icon);
                            continue;
                        }
                        basicIcon = PaginatedMenu.buildPageIcon(i2);
                        sheet.addIcon(i2, basicIcon);
                    }
                    catch (Throwable e) {
                        BukkitOfUtils.getInstance().logSevere("Error while building not filled icon", e);
                        basicIcon = PaginatedMenu.buildPageIcon(i2);
                        sheet.addIcon(i2, basicIcon);
                    }
                    continue;
                }
                catch (Throwable e) {
                    BukkitOfUtils.getInstance().logSevere("Error while building icon", e);
                    basicIcon = PaginatedMenu.buildPageIcon(i2);
                    sheet.addIcon(i2, basicIcon);
                }
            }
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logSevere("Error while building sheet", e);
        }
        return sheet;
    }

    public void previousPage() {
        try {
            --this.currentPage;
            if (this.currentPage < 1) {
                this.currentPage = 1;
            }
            this.openPage(this.currentPage);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logSevere("Error while going to previous page", e);
        }
    }

    public void nextPage() {
        try {
            ++this.currentPage;
            int maxPages = PaginatedMenu.getMaxPages(this.fullSlots, this.slotsPerPage);
            if (this.currentPage > maxPages) {
                this.currentPage = maxPages;
            }
            this.openPage(this.currentPage);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logSevere("Error while going to next page", e);
        }
    }

    public static Icon buildPageIcon(int index) {
        try {
            if (index < 45) {
                return PaginatedMenu.buildFillerIcon();
            }
            if (index == 45) {
                return PaginatedMenu.buildPreviousPageIcon();
            }
            if (index == 53) {
                return PaginatedMenu.buildNextPageIcon();
            }
            return PaginatedMenu.buildAirSlot();
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logSevere("Error while building page icon", e);
            return new BasicIcon(ItemUtils.make(Material.AIR, "", new String[0]));
        }
    }

    public static Icon buildAirSlot() {
        return new BasicIcon(ItemUtils.make(Material.AIR, "", new String[0]));
    }

    public static ItemStack getPreviousPageItemStack() {
        return ItemUtils.make(Material.ARROW, "&bPrevious Page", new String[0]);
    }

    public static ItemStack getNextPageItemStack() {
        return ItemUtils.make(Material.ARROW, "&bNext Page", new String[0]);
    }

    public static Icon buildPreviousPageIcon() {
        return new BasicIcon(PaginatedMenu.getPreviousPageItemStack()).onClick(PaginatedMenu::previousPage);
    }

    public static Icon buildNextPageIcon() {
        return new BasicIcon(PaginatedMenu.getNextPageItemStack()).onClick(PaginatedMenu::nextPage);
    }

    public static void previousPage(InventoryEvent event) {
        Inventory inventory = event.getInventory();
        Optional<ScreenInstance> optional = ScreenManager.getScreen(inventory);
        if (optional.isEmpty()) {
            return;
        }
        ScreenInstance screen = optional.get();
        screen.getViewers().forEach((uuid, viewer) -> {
            if (viewer instanceof Player) {
                Player player = (Player)viewer;
                if (screen instanceof TaskMenu) {
                    TaskMenu taskMenu = (TaskMenu)screen;
                    taskMenu.previousPage();
                }
            }
        });
    }

    public static void nextPage(InventoryEvent event) {
        Inventory inventory = event.getInventory();
        Optional<ScreenInstance> optional = ScreenManager.getScreen(inventory);
        if (optional.isEmpty()) {
            return;
        }
        ScreenInstance screen = optional.get();
        screen.getViewers().forEach((uuid, viewer) -> {
            if (viewer instanceof Player) {
                Player player = (Player)viewer;
                if (screen instanceof TaskMenu) {
                    TaskMenu taskMenu = (TaskMenu)screen;
                    taskMenu.nextPage();
                }
            }
        });
    }

    public static ItemStack getFiller() {
        Material material;
        try {
            material = Material.BLACK_STAINED_GLASS_PANE;
        }
        catch (Throwable e) {
            try {
                material = Material.valueOf((String)"BLACK_STAINED_GLASS_PANE");
            }
            catch (Throwable t2) {
                try {
                    material = Material.valueOf((String)"STAINED_GLASS_PANE");
                }
                catch (Throwable legacyEx) {
                    BukkitOfUtils.getInstance().logSevere("Could not find material for filler icon", legacyEx);
                    material = Material.AIR;
                }
            }
        }
        return ItemUtils.make(material, "", new String[0]);
    }

    public static Icon buildFillerIcon() {
        try {
            return new BasicIcon(PaginatedMenu.getFiller()).onClick(PaginatedMenu::fillerAction).onDrag(PaginatedMenu::fillerAction);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logSevere("Error while building filler icon", e);
            return new BasicIcon(ItemUtils.make(Material.AIR, "", new String[0]));
        }
    }

    public static void fillerAction(InventoryEvent event) {
        event.getViewers().forEach(viewer -> {
            if (viewer instanceof Player) {
                Player player = (Player)viewer;
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            }
        });
    }

    public void openPage(int page) {
        InventorySheet sheet = PaginatedMenu.buildSheet(this.player, this.fullSlots, page, this.slotsPerPage, this.padLeft, this.padRight, this.padTop, this.padBottom, this.whenNotFilled, this.whenFilled);
        this.setInventorySheet(sheet);
        this.open();
    }

    @Override
    public void redraw() {
        this.openPage(this.currentPage);
    }

    public static int getMaxPages(ManagedInventory fullSlots, int pageSize) {
        return (int)Math.ceil((double)fullSlots.size() / (double)pageSize);
    }

    public static boolean isFillable(InventorySheet sheet, int currentIndex, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom) {
        return PaginatedMenu.getPageIndexOfSheetSlot(sheet, currentIndex, slotsPerPage, padLeft, padRight, padTop, padBottom) != -1;
    }

    public static int getPageIndexOfSheetSlot(InventorySheet sheet, int currentIndex, int slotsPerPage, int padLeft, int padRight, int padTop, int padBottom) {
        int hardMaxRows = sheet.getRows();
        int hardMaxCols = 9;
        int rowStart = padTop;
        if (rowStart >= hardMaxRows) {
            return -1;
        }
        int rowEnd = hardMaxRows - padBottom;
        if (rowEnd <= rowStart) {
            return -1;
        }
        int colStart = padLeft;
        if (colStart >= hardMaxCols) {
            return -1;
        }
        int colEnd = hardMaxCols - padRight;
        if (colEnd <= colStart) {
            return -1;
        }
        if (currentIndex < 0 || currentIndex >= sheet.getSize()) {
            return -1;
        }
        int row = currentIndex / hardMaxCols;
        int col = currentIndex % hardMaxCols;
        if (row < rowStart || row >= rowEnd || col < colStart || col >= colEnd) {
            return -1;
        }
        int maxRowSlots = rowEnd - rowStart;
        int pageRow = row - rowStart;
        int maxColSlots = colEnd - colStart;
        int pageCol = col - colStart;
        int pageIndex = pageRow * maxColSlots + pageCol;
        return pageIndex < slotsPerPage ? pageIndex : -1;
    }

    public ManagedInventory getFullSlots() {
        return this.fullSlots;
    }

    public int getSlotsPerPage() {
        return this.slotsPerPage;
    }

    public int getPadLeft() {
        return this.padLeft;
    }

    public int getPadRight() {
        return this.padRight;
    }

    public int getPadTop() {
        return this.padTop;
    }

    public int getPadBottom() {
        return this.padBottom;
    }

    public BiFunction<Player, Integer, Icon> getWhenNotFilled() {
        return this.whenNotFilled;
    }

    public BiFunction<Player, Integer, Icon> getWhenFilled() {
        return this.whenFilled;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setFullSlots(ManagedInventory fullSlots) {
        this.fullSlots = fullSlots;
    }

    public void setSlotsPerPage(int slotsPerPage) {
        this.slotsPerPage = slotsPerPage;
    }

    public void setPadLeft(int padLeft) {
        this.padLeft = padLeft;
    }

    public void setPadRight(int padRight) {
        this.padRight = padRight;
    }

    public void setPadTop(int padTop) {
        this.padTop = padTop;
    }

    public void setPadBottom(int padBottom) {
        this.padBottom = padBottom;
    }

    public void setWhenNotFilled(BiFunction<Player, Integer, Icon> whenNotFilled) {
        this.whenNotFilled = whenNotFilled;
    }

    public void setWhenFilled(BiFunction<Player, Integer, Icon> whenFilled) {
        this.whenFilled = whenFilled;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
}

