/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui.screens;

import gg.drak.thebase.objects.Identified;
import host.plas.bou.gui.GuiType;
import host.plas.bou.gui.InventorySheet;
import host.plas.bou.gui.ScreenManager;
import host.plas.bou.gui.screens.blocks.ScreenBlock;
import host.plas.bou.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import mc.obliviate.inventory.Gui;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class ScreenInstance
extends Gui
implements Identified {
    private final String identifier;
    private GuiType type;
    private Optional<ScreenBlock> screenBlock;
    private InventorySheet inventorySheet;
    private boolean noPlace;

    public ScreenInstance(@NotNull Player player, GuiType type, InventorySheet inventorySheet, boolean noPlace) {
        super(player, type.name(), ColorUtils.colorizeHard(ScreenInstance.getTitleByType(type)), inventorySheet.getRows());
        this.identifier = player.getUniqueId().toString();
        this.type = type;
        this.screenBlock = Optional.empty();
        this.inventorySheet = inventorySheet;
        this.noPlace = noPlace;
    }

    public ScreenInstance(@NotNull Player player, GuiType type, InventorySheet inventorySheet) {
        this(player, type, inventorySheet, true);
    }

    public void setBlock(ScreenBlock block) {
        this.screenBlock = Optional.of(block);
    }

    public static String getTitleByType(GuiType type) {
        return type.getTitle();
    }

    public void updateSize(int size) {
        super.setSize(size);
    }

    public void updateTitle(String title) {
        super.setTitle(title);
    }

    public void build(InventorySheet sheet) {
        sheet.getSlots().forEach(s2 -> this.addItem(s2.getIndex(), s2.getIcon()));
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        super.onClose(event);
        this.getScreenBlock().ifPresent(block -> block.onClose((Player)event.getPlayer()));
    }

    @Override
    public void onOpen(InventoryOpenEvent event) {
        this.build(this.inventorySheet);
        ScreenManager.setScreen(this.player, this);
    }

    @Override
    public boolean onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return false;
        }
        Player p = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        Inventory clickedInventory = event.getClickedInventory();
        PlayerInventory playerInventory = p.getInventory();
        if (clickedInventory == null || playerInventory == null) {
            return false;
        }
        boolean isPlace = false;
        InventoryAction action = event.getAction();
        if (clickedInventory.equals(playerInventory)) {
            if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                isPlace = true;
            }
        } else {
            if (action == InventoryAction.DROP_ALL_CURSOR || action == InventoryAction.DROP_ONE_CURSOR || action == InventoryAction.PLACE_ALL || action == InventoryAction.PLACE_ONE || action == InventoryAction.PLACE_SOME) {
                isPlace = true;
            }
            if (!isPlace && cursor.getType() != Material.AIR && action == InventoryAction.SWAP_WITH_CURSOR) {
                isPlace = true;
            }
        }
        if (isPlace && this.noPlace) {
            event.setCancelled(true);
            return false;
        }
        return this.furtherClick(event);
    }

    public boolean furtherClick(InventoryClickEvent event) {
        return false;
    }

    public void close() {
        this.player.closeInventory();
    }

    public void redraw() {
        this.redraw(true);
    }

    public void redraw(boolean reshow) {
        this.build(this.inventorySheet);
        if (reshow) {
            this.reshow();
        }
    }

    public void reshow() {
        this.close();
        this.open();
    }

    public ConcurrentSkipListMap<String, HumanEntity> getViewers() {
        ConcurrentSkipListMap<String, HumanEntity> map = new ConcurrentSkipListMap<String, HumanEntity>();
        ArrayList viewers = new ArrayList(this.getInventory().getViewers());
        viewers.forEach(v -> {
            if (v instanceof Player) {
                map.put(v.getUniqueId().toString(), (HumanEntity)v);
            }
        });
        return map;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public GuiType getType() {
        return this.type;
    }

    public Optional<ScreenBlock> getScreenBlock() {
        return this.screenBlock;
    }

    public InventorySheet getInventorySheet() {
        return this.inventorySheet;
    }

    public boolean isNoPlace() {
        return this.noPlace;
    }

    public void setType(GuiType type) {
        this.type = type;
    }

    public void setScreenBlock(Optional<ScreenBlock> screenBlock) {
        this.screenBlock = screenBlock;
    }

    public void setInventorySheet(InventorySheet inventorySheet) {
        this.inventorySheet = inventorySheet;
    }

    public void setNoPlace(boolean noPlace) {
        this.noPlace = noPlace;
    }
}

