/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.gui.screens.blocks;

import gg.drak.thebase.objects.Identifiable;
import host.plas.bou.gui.GuiType;
import host.plas.bou.gui.InventorySheet;
import host.plas.bou.gui.ScreenManager;
import host.plas.bou.gui.screens.ScreenInstance;
import host.plas.bou.gui.screens.events.BlockCloseEvent;
import host.plas.bou.gui.screens.events.BlockOpenEvent;
import host.plas.bou.gui.screens.events.BlockRedrawEvent;
import mc.obliviate.inventory.Gui;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public abstract class ScreenBlock
implements Identifiable {
    private GuiType type;
    private Location location;

    @Override
    public String getIdentifier() {
        return this.type.name().toLowerCase();
    }

    public ScreenBlock(GuiType type, Location location) {
        this.type = type;
        this.location = location;
    }

    public Block getBlock() {
        return this.location.getBlock();
    }

    public void onRightClick(Player player) {
        BlockOpenEvent event = (BlockOpenEvent)new BlockOpenEvent(player, this).fire();
        if (!event.isCancelled()) {
            this.onOpen(event);
        }
    }

    public void onClose(Player player) {
        BlockCloseEvent event = (BlockCloseEvent)new BlockCloseEvent(player, this).fire();
        if (!event.isCancelled()) {
            this.onClose(event);
        }
    }

    public void onRedraw() {
        BlockRedrawEvent event = (BlockRedrawEvent)new BlockRedrawEvent(this).fire();
        if (!event.isCancelled()) {
            this.onRedraw(event);
        }
    }

    public void onOpen(BlockOpenEvent event) {
        Player player = event.getPlayer();
        if (ScreenManager.hasScreen(player) && !event.isOverride()) {
            ScreenManager.getScreen(player).ifPresent(Gui::open);
            return;
        }
        this.buildScreen(event).open();
    }

    public void onClose(BlockCloseEvent event) {
        Player player = event.getPlayer();
        ScreenManager.removeScreen(player);
    }

    public abstract InventorySheet buildInventorySheet(Player var1, ScreenBlock var2);

    public abstract String buildTitle(Player var1, ScreenBlock var2);

    public ScreenInstance buildScreen(BlockOpenEvent event) {
        Player player = event.getPlayer();
        ScreenBlock block = event.getScreenBlock();
        InventorySheet inventorySheet = this.buildInventorySheet(player, block);
        ScreenInstance instance = new ScreenInstance(player, this.getType(), inventorySheet);
        instance.setBlock(block);
        instance.setTitle(this.buildTitle(player, block));
        return instance;
    }

    public void onRedraw(BlockRedrawEvent event) {
        ScreenBlock block = event.getScreenBlock();
        ScreenManager.getPlayersOf(block).forEach(ScreenInstance::redraw);
    }

    public void redraw() {
        BlockRedrawEvent event = (BlockRedrawEvent)new BlockRedrawEvent(this).fire();
    }

    public GuiType getType() {
        return this.type;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setType(GuiType type) {
        this.type = type;
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

