/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.instances;

import host.plas.bou.BetterPlugin;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.configs.BaseConfig;
import host.plas.bou.events.MainListener;
import host.plas.bou.events.callbacks.CallbackManager;
import host.plas.bou.libs.universalScheduler.UniversalScheduler;
import host.plas.bou.scheduling.TaskManager;
import host.plas.bou.utils.EntityUtils;
import host.plas.bou.utils.PluginUtils;
import host.plas.bou.utils.VersionTool;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import mc.obliviate.inventory.InventoryAPI;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BaseManager {
    private static BaseConfig baseConfig;
    private static MainListener mainListener;

    public static BukkitOfUtils getBaseInstance() {
        return BukkitOfUtils.getInstance();
    }

    public static BaseConfig getBaseConfig() {
        BaseManager.ensureConfig();
        return baseConfig;
    }

    public static void init(BukkitOfUtils baseInstance) {
        BaseManager.preInit(baseInstance);
        CallbackManager.init();
        VersionTool.init();
    }

    public static void preInit(BukkitOfUtils baseInstance) {
        BaseManager.ensureConfig();
        BetterPlugin.setScheduler(UniversalScheduler.getScheduler((Plugin)baseInstance));
    }

    public static void initOnEnabled() {
        new InventoryAPI(BaseManager.getBaseInstance()).init();
        mainListener = new MainListener();
        TaskManager.init();
        EntityUtils.init();
    }

    public static void ensureConfig() {
        if (baseConfig == null) {
            BaseManager.setBaseConfig(new BaseConfig(BukkitOfUtils.getInstance()));
        }
    }

    public static void otherInit(BetterPlugin otherInstance) {
        PluginUtils.registerPlugin(otherInstance);
        new InventoryAPI(otherInstance).init();
    }

    public static void stop() {
        EntityUtils.getLookupTimer().cancel();
        TaskManager.stop();
    }

    public static World getMainWorld() {
        WeakReference<World> world = new WeakReference<World>((World)Bukkit.getWorlds().get(0));
        if (world.get() == null) {
            throw new NullPointerException("Main world is null.");
        }
        return (World)world.get();
    }

    public static CommandSender getConsole() {
        return Bukkit.getConsoleSender();
    }

    public static List<Player> getOnlinePlayers() {
        return new ArrayList<Player>(Bukkit.getOnlinePlayers());
    }

    public static ConcurrentSkipListMap<String, Player> getOnlinePlayersByUUID() {
        ConcurrentSkipListMap<String, Player> players = new ConcurrentSkipListMap<String, Player>();
        for (Player player : BaseManager.getOnlinePlayers()) {
            players.put(player.getUniqueId().toString(), player);
        }
        return players;
    }

    public static ConcurrentSkipListMap<String, Player> getOnlinePlayersByName() {
        ConcurrentSkipListMap<String, Player> players = new ConcurrentSkipListMap<String, Player>();
        for (Player player : BaseManager.getOnlinePlayers()) {
            players.put(player.getName(), player);
        }
        return players;
    }

    public static Player getPlayerByUUID(String uuid) {
        return BaseManager.getOnlinePlayersByUUID().get(uuid);
    }

    public static Player getPlayerByName(String name) {
        return BaseManager.getOnlinePlayersByName().get(name);
    }

    public static void setBaseConfig(BaseConfig baseConfig) {
        BaseManager.baseConfig = baseConfig;
    }

    public static MainListener getMainListener() {
        return mainListener;
    }

    public static void setMainListener(MainListener mainListener) {
        BaseManager.mainListener = mainListener;
    }
}

