/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items;

import host.plas.bou.items.ItemBin;
import host.plas.bou.items.ItemUtils;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConvertableItemStack
implements Comparable<ConvertableItemStack> {
    private UUID uuid = ItemBin.getNextUUID();
    private int stashedId = ItemBin.getNextId();
    private Optional<ItemStack> itemStackOptional;
    private Optional<String> itemStringOptional;

    public ConvertableItemStack(ItemStack itemStack, String itemString) {
        this.itemStackOptional = Optional.ofNullable(itemStack);
        this.itemStringOptional = Optional.ofNullable(itemString);
        this.convert();
    }

    public ConvertableItemStack(ItemStack itemStack) {
        this(itemStack, null);
    }

    public ConvertableItemStack(String itemString) {
        this(null, itemString);
    }

    public ConvertableItemStack() {
        this(null, null);
    }

    public ConvertableItemStack convert() {
        if (this.itemStackOptional.isPresent() && this.itemStringOptional.isEmpty()) {
            this.itemStringOptional = Optional.of(ItemUtils.getItemNBTStrict(this.itemStackOptional.get()));
        } else if (this.itemStackOptional.isEmpty() && this.itemStringOptional.isPresent()) {
            this.itemStackOptional = this.isNbtStrict() ? ItemUtils.getItemStrict(this.itemStringOptional.get()) : ItemUtils.getItem(this.itemStringOptional.get());
        }
        return this;
    }

    public boolean isNbtStrict() {
        return this.itemStringOptional.isPresent() && !this.itemStringOptional.get().startsWith("{") && !this.itemStringOptional.get().endsWith("}");
    }

    public ConvertableItemStack setItemStack(ItemStack itemStack) {
        this.itemStackOptional = Optional.ofNullable(itemStack);
        return this;
    }

    public ConvertableItemStack setItemString(String itemString) {
        this.itemStringOptional = Optional.ofNullable(itemString);
        return this;
    }

    public ItemStack getItemStack() {
        return this.itemStackOptional.orElse(null);
    }

    public String getItemString() {
        return this.itemStringOptional.orElse("{}");
    }

    public ConvertableItemStack prepare() {
        if (!(!this.itemStackOptional.isEmpty() && !this.itemStringOptional.isEmpty() || this.itemStackOptional.isEmpty() && this.itemStringOptional.isEmpty())) {
            this.convert();
        }
        return this;
    }

    public ConvertableItemStack stash() {
        ItemBin.add(this);
        return this;
    }

    public ConvertableItemStack unstash() {
        ItemBin.remove(this);
        return this;
    }

    @Override
    public int compareTo(@NotNull ConvertableItemStack o) {
        this.prepare();
        if (this.getItemStackOptional().isPresent()) {
            return this.getItemStack().equals((Object)o.getItemStack()) ? 0 : 1;
        }
        return this.getUuid().compareTo(o.getUuid());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getStashedId() {
        return this.stashedId;
    }

    public Optional<ItemStack> getItemStackOptional() {
        return this.itemStackOptional;
    }

    public Optional<String> getItemStringOptional() {
        return this.itemStringOptional;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setStashedId(int stashedId) {
        this.stashedId = stashedId;
    }

    public void setItemStackOptional(Optional<ItemStack> itemStackOptional) {
        this.itemStackOptional = itemStackOptional;
    }

    public void setItemStringOptional(Optional<String> itemStringOptional) {
        this.itemStringOptional = itemStringOptional;
    }
}

