/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items;

import gg.drak.thebase.lib.leonhard.storage.sections.FlatFileSection;
import gg.drak.thebase.objects.Identified;
import host.plas.bou.items.ItemUtils;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.inventory.Recipe;

public class CraftingConfig
implements Identified {
    private String identifier;
    private String line1;
    private String line2;
    private String line3;
    private ConcurrentSkipListMap<String, String> ingredients;
    private String result;

    public CraftingConfig(String identifier, String line1, String line2, String line3, ConcurrentSkipListMap<String, String> ingredients, String result) {
        this.identifier = identifier;
        this.line1 = line1;
        this.line2 = line2;
        this.line3 = line3;
        this.ingredients = ingredients;
        this.result = result;
    }

    public void register() {
        ItemUtils.registerRecipe(this);
    }

    public Recipe getRecipe() {
        return ItemUtils.getRecipe(this);
    }

    public static CraftingConfig fromConfig(FlatFileSection section) {
        return new CraftingConfig(section.getString("identifier"), section.getString("line1"), section.getString("line2"), section.getString("line3"), CraftingConfig.getIngredients(section), section.getString("result"));
    }

    public static ConcurrentSkipListMap<String, String> getIngredients(FlatFileSection section) {
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        for (String key : section.singleLayerKeySet("ingredients")) {
            map.put(key, section.getString(key));
        }
        return map;
    }

    public void save(FlatFileSection section) {
        section.set("identifier", (Object)this.getIdentifier());
        section.set("line1", (Object)this.getLine1());
        section.set("line2", (Object)this.getLine2());
        section.set("line3", (Object)this.getLine3());
        section.set("ingredients", this.getIngredients());
        section.set("result", (Object)this.getResult());
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getLine1() {
        return this.line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public String getLine3() {
        return this.line3;
    }

    public ConcurrentSkipListMap<String, String> getIngredients() {
        return this.ingredients;
    }

    public String getResult() {
        return this.result;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public void setLine3(String line3) {
        this.line3 = line3;
    }

    public void setIngredients(ConcurrentSkipListMap<String, String> ingredients) {
        this.ingredients = ingredients;
    }

    public void setResult(String result) {
        this.result = result;
    }
}

