/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items;

import host.plas.bou.gui.InventorySheet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryUtils {
    public static int getSlotFromEquipment(Player player, EquipmentSlot slot) {
        int i2 = -1;
        switch (slot) {
            case HAND: {
                i2 = player.getInventory().getHeldItemSlot();
                break;
            }
            case OFF_HAND: {
                i2 = 40;
                break;
            }
            case HEAD: {
                i2 = 39;
                break;
            }
            case CHEST: {
                i2 = 38;
                break;
            }
            case LEGS: {
                i2 = 37;
                break;
            }
            case FEET: {
                i2 = 36;
            }
        }
        return i2;
    }

    public static void setItemAmount(Player player, ItemStack stack, int slot, int amount) {
        if (amount > 64) {
            stack.setAmount(64);
            while (amount > 64) {
                ItemStack clone = stack.clone();
                clone.setAmount(amount -= 64);
                player.getInventory().addItem(new ItemStack[]{clone});
            }
        } else if (amount <= 0) {
            player.getInventory().setItem(slot, new ItemStack(Material.AIR));
        } else {
            stack.setAmount(amount);
            player.getInventory().setItem(slot, stack);
        }
    }

    public static void clearInventory(Player player) {
        ItemStack air = new ItemStack(Material.AIR);
        InventoryUtils.getInventoryContents(player).forEach((slot, stack) -> {
            if (stack == null) {
                return;
            }
            if (stack.getType() == Material.AIR) {
                return;
            }
            player.getInventory().setItem(slot.intValue(), air);
        });
    }

    public static ConcurrentSkipListMap<Integer, ItemStack> getInventoryContents(Player player) {
        return InventoryUtils.getInventoryContents((Inventory)player.getInventory());
    }

    public static ConcurrentSkipListMap<Integer, ItemStack> getInventoryContents(Inventory inventory) {
        ConcurrentSkipListMap<Integer, ItemStack> items = new ConcurrentSkipListMap<Integer, ItemStack>();
        int i2 = 0;
        for (ItemStack stack : inventory.getContents()) {
            if (stack == null) {
                items.put(i2, new ItemStack(Material.AIR));
            } else {
                items.put(i2, stack);
            }
            ++i2;
        }
        return items;
    }

    public static void clearInventory(Inventory inventory) {
        ItemStack air = new ItemStack(Material.AIR);
        InventoryUtils.getInventoryContents(inventory).forEach((slot, stack) -> {
            if (stack == null) {
                return;
            }
            if (stack.getType() == Material.AIR) {
                return;
            }
            inventory.setItem(slot.intValue(), air);
        });
    }

    public static void setInventoryContents(Inventory inventory, ConcurrentSkipListMap<Integer, ItemStack> items) {
        items.forEach((slot, stack) -> {
            if (stack == null) {
                return;
            }
            if (stack.getType() == Material.AIR) {
                return;
            }
            inventory.setItem(slot.intValue(), stack);
        });
    }

    public static void setInventory(Inventory inventory, Player player) {
        InventoryUtils.clearInventory(player);
        InventoryUtils.getInventoryContents(inventory).forEach((slot, stack) -> {
            if (slot < 0) {
                return;
            }
            if (stack == null) {
                return;
            }
            if (stack.getType() == Material.AIR) {
                return;
            }
            if (slot >= inventory.getSize()) {
                return;
            }
            player.getInventory().setItem(slot.intValue(), stack);
        });
    }

    public static int getItemAmount(Inventory inventory, Predicate<ItemStack> predicate) {
        AtomicInteger amount = new AtomicInteger(0);
        InventoryUtils.getInventoryContents(inventory).forEach((slot, stack) -> {
            if (stack == null) {
                return;
            }
            if (predicate.test((ItemStack)stack)) {
                amount.getAndAdd(stack.getAmount());
            }
        });
        return amount.get();
    }

    public static void setItemMaxDurability(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.getType() == Material.AIR) {
            return;
        }
        if (!(stack instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)stack.getItemMeta();
        if (damageable == null) {
            return;
        }
        short maxDurability = stack.getType().getMaxDurability();
        if (maxDurability > 0) {
            damageable.setDamage(0);
            stack.setItemMeta((ItemMeta)damageable);
        }
    }

    public static void decrementItemAmount(Player player, ItemStack stack, int slot, int amount) {
        int currentAmount = stack.getAmount();
        int newAmount = currentAmount - amount;
        InventoryUtils.setItemAmount(player, stack, slot, newAmount);
    }

    public static void incrementItemAmount(Player player, ItemStack stack, int slot, int amount) {
        int currentAmount = stack.getAmount();
        int newAmount = currentAmount + amount;
        InventoryUtils.setItemAmount(player, stack, slot, newAmount);
    }

    public static int getFistEmptySlot(InventorySheet sheet) {
        AtomicInteger slot = new AtomicInteger(0);
        AtomicBoolean found = new AtomicBoolean(false);
        sheet.getSlots().forEach(value -> {
            if (found.get()) {
                return;
            }
            int i2 = slot.incrementAndGet();
            if (value == null) {
                found.set(true);
            }
        });
        if (!found.get()) {
            return -1;
        }
        return slot.get();
    }

    public static void setGlowing(ItemStack stack, boolean glowing) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return;
        }
        if (glowing) {
            meta.addEnchant(Enchantment.DIG_SPEED, 1, true);
        } else {
            meta.getEnchants().forEach((enchantment, integer) -> {
                if (enchantment == Enchantment.DIG_SPEED) {
                    meta.removeEnchant(enchantment);
                }
            });
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        stack.setItemMeta(meta);
    }

    public static void setGlowing(ItemStack stack) {
        InventoryUtils.setGlowing(stack, true);
    }

    public static void stripPluginKeys(ItemStack stack, JavaPlugin plugin) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.getPersistentDataContainer().getKeys().forEach(key -> {
            if (key.getNamespace().equalsIgnoreCase(plugin.getName())) {
                meta.getPersistentDataContainer().remove(key);
            }
        });
        stack.setItemMeta(meta);
    }
}

