/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.compat.papi.PAPICompat;
import host.plas.bou.items.CraftingConfig;
import host.plas.bou.serialization.items.ItemStackSerializer;
import host.plas.bou.utils.ColorUtils;
import host.plas.bou.utils.EntityUtils;
import host.plas.bou.utils.PluginUtils;
import host.plas.bou.utils.VersionTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemUtils {
    private static ItemStackSerializer stackSerializer = new ItemStackSerializer();

    public static void registerRecipe(CraftingConfig config) {
        try {
            Bukkit.getServer().removeRecipe(PluginUtils.getPluginKey(BukkitOfUtils.getInstance(), config.getIdentifier()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Bukkit.getServer().addRecipe(ItemUtils.getRecipe(config));
    }

    public static Recipe getRecipe(CraftingConfig config) {
        ShapedRecipe recipe = new ShapedRecipe(PluginUtils.getPluginKey(BukkitOfUtils.getInstance(), config.getIdentifier()), ItemUtils.getCraftingResult(config));
        recipe.shape(new String[]{config.getLine1(), config.getLine2(), config.getLine3()});
        for (String key : config.getIngredients().keySet()) {
            recipe.setIngredient(key.charAt(0), ItemUtils.getItemAbs(config.getIngredients().get(key)).getType());
        }
        return recipe;
    }

    public static ItemStack getCraftingResult(CraftingConfig config) {
        return ItemUtils.getItemAbs(config.getResult());
    }

    public static ItemStack getItemAbs(String nbt) {
        return ItemUtils.getItem(nbt).orElse(new ItemStack(Material.AIR));
    }

    public static Optional<ItemStack> getItem(String nbt) {
        try {
            return Optional.ofNullable(VersionTool.getBukkitItemStackFromJsonString(nbt));
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to get item from NBT: ", e);
            return Optional.empty();
        }
    }

    public static String getItemNBT(ItemStack item) {
        try {
            return VersionTool.getJsonStringFromBukkitItemStack(item);
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to get NBT from item: ", e);
            return "{}";
        }
    }

    public static Optional<ItemStack> getItemStrict(String serialized) {
        try {
            ItemStack stack = ItemUtils.getStackSerializer().fromString(serialized);
            return Optional.ofNullable(stack);
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to get item from NBT: ", e);
            return Optional.empty();
        }
    }

    public static String getItemNBTStrict(ItemStack item) {
        try {
            return ItemUtils.getStackSerializer().toString(item);
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to get NBT from item: ", e);
            return "{}";
        }
    }

    public static boolean isItemEqual(ItemStack item1, ItemStack item2) {
        return ItemUtils.getItemNBT(item1).equals(ItemUtils.getItemNBT(item2));
    }

    public static boolean isNothingItem(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR;
    }

    public static ConcurrentSkipListMap<Integer, String> loreToMap(String ... loreLines) {
        ConcurrentSkipListMap<Integer, String> lore = new ConcurrentSkipListMap<Integer, String>();
        for (int i2 = 0; i2 < loreLines.length; ++i2) {
            lore.put(i2, loreLines[i2]);
        }
        return lore;
    }

    public static List<String> mapToLore(ConcurrentSkipListMap<Integer, String> loreMap) {
        return new ArrayList<String>(loreMap.values());
    }

    public static String compute(OfflinePlayer player, String input) {
        input = PAPICompat.replace(player, input);
        input = ColorUtils.colorizeHard(input);
        return input;
    }

    public static String compute(String input) {
        return ItemUtils.compute(EntityUtils.getDummyOfflinePlayer(), input);
    }

    public static ItemStack make(OfflinePlayer player, Material material, String displayName, boolean format, Collection<String> loreLines) {
        return ItemUtils.make(player, material, displayName, format, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(OfflinePlayer player, String material, String displayName, boolean format, Collection<String> loreLines) {
        return ItemUtils.make(player, material, displayName, format, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(OfflinePlayer player, Material material, String displayName, Collection<String> loreLines) {
        return ItemUtils.make(player, material, displayName, true, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(OfflinePlayer player, String material, String displayName, Collection<String> loreLines) {
        return ItemUtils.make(player, material, displayName, true, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(OfflinePlayer player, Material material, String displayName, boolean format, String ... loreLines) {
        ItemStack item = new ItemStack(material);
        ConcurrentSkipListMap<Integer, String> lore = ItemUtils.loreToMap(loreLines);
        lore.forEach((index, line) -> {
            if (format) {
                line = ItemUtils.compute(player, line);
            }
            lore.put((Integer)index, (String)line);
        });
        List<String> loreList = ItemUtils.mapToLore(lore);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ItemUtils.compute(player, displayName));
            meta.setLore(loreList);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack make(OfflinePlayer player, String material, String displayName, boolean format, String ... loreLines) {
        return ItemUtils.make(player, material, displayName, format, loreLines);
    }

    public static ItemStack make(OfflinePlayer player, Material material, String displayName, String ... loreLines) {
        return ItemUtils.make(player, material, displayName, true, loreLines);
    }

    public static ItemStack make(OfflinePlayer player, String material, String displayName, String ... loreLines) {
        return ItemUtils.make(player, material, displayName, true, loreLines);
    }

    public static ItemStack make(Material material, String displayName, Collection<String> loreLines) {
        return ItemUtils.make(material, displayName, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(String material, String displayName, Collection<String> loreLines) {
        return ItemUtils.make(material, displayName, loreLines.toArray(new String[0]));
    }

    public static ItemStack make(Material material, String displayName, String ... loreLines) {
        ItemStack item = new ItemStack(material);
        ConcurrentSkipListMap<Integer, String> lore = ItemUtils.loreToMap(loreLines);
        lore.forEach((index, line) -> {
            line = ItemUtils.compute(line);
            lore.put((Integer)index, (String)line);
        });
        List<String> loreList = ItemUtils.mapToLore(lore);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ItemUtils.compute(displayName));
            meta.setLore(loreList);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack make(String material, String displayName, String ... loreLines) {
        return ItemUtils.make(ItemUtils.getMaterial(material).orElse(Material.AIR), displayName, loreLines);
    }

    public static Optional<Material> getMaterial(String material) {
        try {
            return Optional.of(Material.valueOf((String)material.toUpperCase()));
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("Failed to get material: ", e);
            return Optional.empty();
        }
    }

    public static void setTag(ItemStack stack, JavaPlugin plugin, String key, String value) {
        ItemMeta meta = stack.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(PluginUtils.getPluginKey(plugin, key), PersistentDataType.STRING, (Object)value);
            stack.setItemMeta(meta);
        }
    }

    public static Optional<String> getTag(ItemStack stack, JavaPlugin plugin, String key) {
        if (stack == null) {
            return Optional.empty();
        }
        ItemMeta meta = stack.getItemMeta();
        String value = null;
        if (meta != null && meta.getPersistentDataContainer().has(PluginUtils.getPluginKey(plugin, key), PersistentDataType.STRING)) {
            value = (String)meta.getPersistentDataContainer().get(PluginUtils.getPluginKey(plugin, key), PersistentDataType.STRING);
        }
        return Optional.ofNullable(value);
    }

    public static ItemStackSerializer getStackSerializer() {
        return stackSerializer;
    }

    public static void setStackSerializer(ItemStackSerializer stackSerializer) {
        ItemUtils.stackSerializer = stackSerializer;
    }
}

