/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items.droppable;

import gg.drak.thebase.objects.Identifiable;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.items.droppable.DroppableItemKeyedType;
import host.plas.bou.items.droppable.DroppableItemType;
import host.plas.bou.math.CosmicMath;
import java.util.Optional;
import java.util.function.Consumer;

public class DroppableItem
implements Identifiable {
    private String identifier;
    private DroppableItemType type;
    private String itemString;
    private double chance;
    private int minAmount;
    private int maxAmount;

    public DroppableItem(String identifier, DroppableItemType type, String itemString, double chance, int minAmount, int maxAmount) {
        this.identifier = identifier;
        this.type = type;
        this.itemString = itemString;
        this.chance = chance;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    public DroppableItem(String identifier, DroppableItemType type, String itemString, double chance) {
        this(identifier, type, itemString, chance, -1, -1);
    }

    public DroppableItem(String identifier, String itemString, double chance, int minAmount, int maxAmount) {
        this(identifier, DroppableItemType.ITEM, itemString, chance, minAmount, maxAmount);
    }

    public DroppableItem(String identifier, String itemString, double chance) {
        this(identifier, DroppableItemType.ITEM, itemString, chance);
    }

    public Optional<DroppableItemKeyedType> getKeyedType() {
        if (this.getType() != DroppableItemType.KEYED) {
            return Optional.empty();
        }
        try {
            DroppableItemKeyedType keyedType = DroppableItemKeyedType.valueOf(this.getItemString().toUpperCase());
            return Optional.of(keyedType);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to parse keyed type: " + this.getItemString(), e);
            return Optional.empty();
        }
    }

    public boolean hasAmountSpecified() {
        return this.hasMinSpecified() && this.hasMaxSpecified();
    }

    public boolean hasMinSpecified() {
        return this.getMinnedAmount() != -1;
    }

    public boolean hasMaxSpecified() {
        return this.getMaxedAmount() != -1;
    }

    public int getMinnedAmount() {
        return Math.min(this.getMinAmount(), this.getMinAmount());
    }

    public int getMaxedAmount() {
        return Math.max(this.getMaxAmount(), this.getMaxAmount());
    }

    public int getTrueMinAmount() {
        return this.hasMinSpecified() ? Math.min(Math.max(this.getMinnedAmount(), 1), 64) : 1;
    }

    public int getTrueMaxAmount() {
        return this.hasMaxSpecified() ? Math.max(Math.min(this.getMaxedAmount(), 64), 1) : this.getTrueMinAmount();
    }

    public int pollRandomAmount() {
        int max;
        int min2 = this.getTrueMinAmount();
        if (min2 == (max = this.getTrueMaxAmount())) {
            return min2;
        }
        return CosmicMath.getRandomInt(min2, max);
    }

    public void apply(Consumer<DroppableItem> consumer) {
        consumer.accept(this);
    }

    public boolean passesRoll() {
        double roll = CosmicMath.getRandomDouble(0.0, 100.0);
        return roll <= this.getChance();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public DroppableItemType getType() {
        return this.type;
    }

    public String getItemString() {
        return this.itemString;
    }

    public double getChance() {
        return this.chance;
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setType(DroppableItemType type) {
        this.type = type;
    }

    public void setItemString(String itemString) {
        this.itemString = itemString;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public void setMinAmount(int minAmount) {
        this.minAmount = minAmount;
    }

    public void setMaxAmount(int maxAmount) {
        this.maxAmount = maxAmount;
    }
}

