/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.items.droppable;

import gg.drak.thebase.objects.Identifiable;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.items.droppable.DroppableItem;
import host.plas.bou.math.CosmicMath;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class DroppableItemSet
implements Identifiable {
    private String identifier;
    private ConcurrentSkipListSet<String> arenaSet;
    private ConcurrentSkipListSet<DroppableItem> itemSet;

    public DroppableItemSet(String identifier, ConcurrentSkipListSet<String> arenaSet, ConcurrentSkipListSet<DroppableItem> itemSet) {
        this.identifier = identifier;
        this.arenaSet = arenaSet;
        this.itemSet = itemSet;
    }

    public DroppableItemSet(String identifier, ConcurrentSkipListSet<String> arenaSet, DroppableItem ... items) {
        this(identifier, arenaSet, DroppableItemSet.createItemSet(items));
    }

    public DroppableItemSet(String identifier, String arena, DroppableItem ... items) {
        this(identifier, DroppableItemSet.createArenaSet(arena), DroppableItemSet.createItemSet(items));
    }

    public static ConcurrentSkipListSet<String> createArenaSet(String ... arenas) {
        return new ConcurrentSkipListSet<String>(Arrays.asList(arenas));
    }

    public static ConcurrentSkipListSet<DroppableItem> createItemSet(DroppableItem ... items) {
        return new ConcurrentSkipListSet<DroppableItem>(Arrays.asList(items));
    }

    public Optional<DroppableItem> pollItems() {
        ConcurrentSkipListMap itemChances = new ConcurrentSkipListMap();
        this.getItemSet().forEach(item -> {
            double lastChance = itemChances.isEmpty() ? 0.0 : (Double)itemChances.lastKey();
            double itemChance = item.getChance();
            double chance = lastChance + itemChance;
            itemChances.put(chance, item);
        });
        Double lastChance = (Double)itemChances.lastKey();
        if (lastChance == null) {
            return Optional.empty();
        }
        double random = CosmicMath.getRandomDouble(0.0, lastChance);
        try {
            return Optional.ofNullable((DroppableItem)itemChances.ceilingEntry(random).getValue());
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to poll item from DroppableItemSet: " + this.getIdentifier(), e);
            return Optional.empty();
        }
    }

    public boolean checkArena(String arena) {
        return this.getArenaSet().contains(arena);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public ConcurrentSkipListSet<String> getArenaSet() {
        return this.arenaSet;
    }

    public ConcurrentSkipListSet<DroppableItem> getItemSet() {
        return this.itemSet;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setArenaSet(ConcurrentSkipListSet<String> arenaSet) {
        this.arenaSet = arenaSet;
    }

    public void setItemSet(ConcurrentSkipListSet<DroppableItem> itemSet) {
        this.itemSet = itemSet;
    }
}

