/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.caffeine.cache;

import host.plas.bou.libs.caffeine.cache.AsyncCacheLoader;
import host.plas.bou.libs.caffeine.cache.Caffeine;
import host.plas.bou.libs.caffeine.cache.Expiry;
import host.plas.bou.libs.caffeine.cache.LocalCacheFactory;
import host.plas.bou.libs.caffeine.cache.Pacer;
import host.plas.bou.libs.caffeine.cache.SIMW;
import host.plas.bou.libs.caffeine.cache.Scheduler;
import host.plas.bou.libs.caffeine.cache.Ticker;
import host.plas.bou.libs.caffeine.cache.TimerWheel;
import org.checkerframework.checker.nullness.qual.Nullable;

class SIMWA<K, V>
extends SIMW<K, V> {
    static final LocalCacheFactory FACTORY = SIMWA::new;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SIMWA(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

