/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.caffeine.cache;

import host.plas.bou.libs.caffeine.cache.AsyncCacheLoader;
import host.plas.bou.libs.caffeine.cache.Caffeine;
import host.plas.bou.libs.caffeine.cache.LocalCacheFactory;
import host.plas.bou.libs.caffeine.cache.Node;
import host.plas.bou.libs.caffeine.cache.Pacer;
import host.plas.bou.libs.caffeine.cache.Scheduler;
import host.plas.bou.libs.caffeine.cache.Ticker;
import host.plas.bou.libs.caffeine.cache.WILMS;
import host.plas.bou.libs.caffeine.cache.WriteOrderDeque;
import org.checkerframework.checker.nullness.qual.Nullable;

class WILMSW<K, V>
extends WILMS<K, V> {
    static final LocalCacheFactory FACTORY = WILMSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WILMSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

