/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.caffeine.cache;

import host.plas.bou.libs.caffeine.cache.BoundedWeigher;
import host.plas.bou.libs.caffeine.cache.SingletonWeigher;
import org.checkerframework.checker.index.qual.NonNegative;

@FunctionalInterface
public interface Weigher<K, V> {
    public @NonNegative int weigh(K var1, V var2);

    public static <K, V> Weigher<K, V> singletonWeigher() {
        SingletonWeigher instance = SingletonWeigher.INSTANCE;
        return instance;
    }

    public static <K, V> Weigher<K, V> boundedWeigher(Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

