/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.de.leonhard.storage.internal;

import host.plas.bou.libs.de.leonhard.storage.annotation.ConfigPath;
import host.plas.bou.libs.de.leonhard.storage.internal.DataStorage;
import host.plas.bou.libs.de.leonhard.storage.internal.FileData;
import host.plas.bou.libs.de.leonhard.storage.internal.FileType;
import host.plas.bou.libs.de.leonhard.storage.internal.provider.SimplixProviders;
import host.plas.bou.libs.de.leonhard.storage.internal.settings.DataType;
import host.plas.bou.libs.de.leonhard.storage.internal.settings.ErrorHandler;
import host.plas.bou.libs.de.leonhard.storage.internal.settings.ReloadSettings;
import host.plas.bou.libs.de.leonhard.storage.sections.FlatFileSection;
import host.plas.bou.libs.de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import host.plas.bou.libs.de.leonhard.storage.util.FileUtils;
import host.plas.bou.libs.de.leonhard.storage.util.Valid;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public abstract class FlatFile
implements DataStorage,
Comparable<FlatFile> {
    protected final File file;
    protected final FileType fileType;
    protected ReloadSettings reloadSettings = ReloadSettings.INTELLIGENT;
    protected ErrorHandler errorHandler = ErrorHandler.CLEAR;
    protected DataType dataType = DataType.UNSORTED;
    protected FileData fileData;
    @Nullable
    protected Consumer<FlatFile> reloadConsumer;
    @Nullable
    protected Consumer<FlatFile> errorConsumer;
    protected String[] pathPrefix;
    protected final String pathSeparator;
    private long lastLoaded;
    private boolean errorLock = false;

    protected FlatFile(@NonNull String name, @Nullable String path, @NonNull FileType fileType, @Nullable String pathSeparator, @Nullable Consumer<FlatFile> reloadConsumer, @Nullable Consumer<FlatFile> errorConsumer) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        Valid.checkBoolean(!name.isEmpty(), "Name mustn't be empty");
        this.fileType = fileType;
        this.reloadConsumer = reloadConsumer;
        this.errorConsumer = errorConsumer;
        this.pathSeparator = Objects.requireNonNullElse(pathSeparator, ".");
        if (path == null || path.isEmpty()) {
            this.file = new File(FileUtils.replaceExtensions(name) + "." + fileType.getExtension());
        } else {
            String fixedPath = path.replace("\\", "/");
            this.file = new File(fixedPath + File.separator + FileUtils.replaceExtensions(name) + "." + fileType.getExtension());
        }
    }

    protected FlatFile(@NonNull String name, @Nullable String path, @NonNull FileType fileType, @Nullable String pathSeparator, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, fileType, pathSeparator, reloadConsumer, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
    }

    protected FlatFile(@NonNull String name, @Nullable String path, @NonNull FileType fileType, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, fileType, null, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
    }

    protected FlatFile(@NonNull File file, @NonNull FileType fileType, @Nullable String pathSeparator) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
        this.file = file;
        this.fileType = fileType;
        this.pathSeparator = Objects.requireNonNullElse(pathSeparator, ".");
        this.reloadConsumer = null;
        this.errorConsumer = null;
        Valid.checkBoolean(fileType == FileType.fromExtension(file), "Invalid file-extension for file type: '" + fileType + "'", "Extension: '" + FileUtils.getExtension(file) + "'");
    }

    protected FlatFile(@NonNull File file, @NonNull FileType fileType) {
        this(file, fileType, null);
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileType == null) {
            throw new NullPointerException("fileType is marked non-null but is null");
        }
    }

    protected FlatFile(@NonNull File file, @Nullable String pathSeparator) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.reloadConsumer = null;
        this.errorConsumer = null;
        this.pathSeparator = pathSeparator;
        this.fileType = FileType.fromFile(file);
    }

    protected FlatFile(@NonNull File file) {
        this(file, (String)null);
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
    }

    public void setPathPrefix(String pathPrefix) {
        this.setPathPrefix(this.splitPath(pathPrefix));
    }

    public void setPathPrefix(String[] pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String[] getPathPrefixArray() {
        return this.pathPrefix;
    }

    public String getPathPrefix() {
        return this.createPath(this.pathPrefix);
    }

    protected boolean shouldGetEmpty() {
        return this.errorLock && (this.errorHandler == ErrorHandler.EMPTY || this.errorHandler == ErrorHandler.KEEP_OR_EMPTY && this.fileData == null);
    }

    protected boolean shouldSetEmpty() {
        return this.errorLock && (this.errorHandler == ErrorHandler.EMPTY || this.errorHandler == ErrorHandler.KEEP_OR_EMPTY);
    }

    protected final boolean create() {
        return this.createFile(this.file);
    }

    private synchronized boolean createFile(File file) {
        if (file.exists()) {
            this.lastLoaded = System.currentTimeMillis();
            return false;
        }
        FileUtils.getAndMake(file);
        this.lastLoaded = System.currentTimeMillis();
        return true;
    }

    protected abstract Map<String, Object> readToMap() throws IOException;

    protected abstract void write(FileData var1) throws IOException;

    protected void handleReloadException(IOException ioException) {
        String fileName = this.fileType == null ? "File" : this.fileType.name().toLowerCase();
        SimplixProviders.logger().sendError("Exception reloading " + fileName + " '" + this.getName() + "'");
        SimplixProviders.logger().sendError("In '" + FileUtils.getParentDirPath(this.file) + "'");
        SimplixProviders.logger().printStackTrace(ioException);
    }

    @Override
    public synchronized void setRaw(String[] key, Object value) {
        this.reloadIfNeeded();
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to set value to path '" + this.createPath(key) + "' but is lock by an error!");
            return;
        }
        String[] finalKey = this.pathPrefix == null ? key : this.concatenatePath(this.pathPrefix, key);
        this.fileData.insert(finalKey, value);
        this.write();
    }

    @Override
    @Nullable
    public final Object get(String[] key) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return null;
        }
        String[] finalKey = this.pathPrefix == null ? key : this.concatenatePath(this.pathPrefix, key);
        return this.getFileData().get(finalKey);
    }

    @Override
    public String pathSeparator() {
        return this.pathSeparator;
    }

    @Override
    public final boolean contains(String[] key) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return false;
        }
        String[] finalKey = this.pathPrefix == null ? key : this.concatenatePath(this.pathPrefix, key);
        return this.fileData.containsKey(finalKey);
    }

    @Override
    public final Set<String> singleLayerKeySet() {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptySet();
        }
        return this.fileData.singleLayerKeySet();
    }

    @Override
    public final Set<String> singleLayerKeySet(String[] key) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptySet();
        }
        return this.fileData.singleLayerKeySet(key);
    }

    @Override
    public final Set<String> keySet() {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptySet();
        }
        return this.fileData.keySet();
    }

    @Override
    public final Set<String> keySet(String key) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptySet();
        }
        return this.fileData.keySet(key);
    }

    @Override
    public final Set<String> keySet(String[] key) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptySet();
        }
        return this.fileData.keySet(key);
    }

    @Override
    public final synchronized void remove(String[] key) {
        this.reloadIfNeeded();
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to remove value from path '" + this.createPath(key) + "' but is lock by an error!");
            return;
        }
        this.fileData.remove(key);
        this.write();
    }

    public final void putAll(Map<String, Object> map) {
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to set values but is lock by an error!");
            return;
        }
        this.fileData.putAll(map);
        this.write();
    }

    public final void putAllRaw(Map<String[], Object> map) {
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to set values but is lock by an error!");
            return;
        }
        this.fileData.putAllRaw(map);
        this.write();
    }

    public final Map<String, Object> getData() {
        if (this.shouldGetEmpty()) {
            return Collections.emptyMap();
        }
        return this.getFileData().toMap();
    }

    public final List<Object> getAll(String ... keys) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String key : keys) {
            result.add(this.get(key));
        }
        return result;
    }

    public final List<Object> getAllRaw(String[] ... keys) {
        this.reloadIfNeeded();
        if (this.shouldGetEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String[] key : keys) {
            result.add(this.get(key));
        }
        return result;
    }

    public void removeAll(String ... keys) {
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to remove values but is lock by an error!");
            return;
        }
        for (String key : keys) {
            this.fileData.remove(key);
        }
        this.write();
    }

    public void removeAllRaw(String[] ... keys) {
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to remove values but is lock by an error!");
            return;
        }
        for (String[] key : keys) {
            this.fileData.remove(key);
        }
        this.write();
    }

    public final void addDefaultsFromMap(@NonNull Map<String, Object> mapWithDefaults) {
        if (mapWithDefaults == null) {
            throw new NullPointerException("mapWithDefaults is marked non-null but is null");
        }
        this.addDefaultsFromFileData(new FileData(mapWithDefaults, this.dataType));
    }

    public final void addDefaultsFromFileData(@NonNull FileData newData) {
        if (newData == null) {
            throw new NullPointerException("newData is marked non-null but is null");
        }
        this.reloadIfNeeded();
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to set values but is lock by an error!");
            return;
        }
        for (String key : newData.keySet()) {
            if (this.fileData.containsKey(key)) continue;
            this.fileData.insert(key, newData.get(key));
        }
        this.write();
    }

    public final void addDefaultsFromFlatFile(@NonNull FlatFile flatFile) {
        if (flatFile == null) {
            throw new NullPointerException("flatFile is marked non-null but is null");
        }
        this.addDefaultsFromFileData(flatFile.getFileData());
    }

    public final String getName() {
        return this.file.getName();
    }

    public final String getFilePath() {
        return this.file.getAbsolutePath();
    }

    public synchronized void replace(CharSequence target, CharSequence replacement) throws IOException {
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to replace values but is lock by an error!");
            return;
        }
        List<String> lines = Files.readAllLines(this.file.toPath());
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line.replace(target, replacement));
        }
        Files.write(this.file.toPath(), result, new OpenOption[0]);
    }

    public void write() {
        try {
            this.write(this.fileData);
        }
        catch (IOException ex) {
            SimplixProviders.logger().sendError("Exception writing to file '" + this.getName() + "'");
            SimplixProviders.logger().sendError("In '" + FileUtils.getParentDirPath(this.file) + "'");
            SimplixProviders.logger().printStackTrace(ex);
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    public final boolean hasChanged() {
        return FileUtils.hasChanged(this.file, this.lastLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceReload() {
        boolean shouldThrow = false;
        Map<Object, Object> out = new HashMap();
        try {
            out = this.readToMap();
            this.errorLock = false;
        }
        catch (IOException ex) {
            this.handleReloadException(ex);
            this.errorLock = true;
        }
        finally {
            boolean ex = this.errorLock;
            boolean shouldModify = true;
            if (this.errorLock) {
                switch (this.errorHandler) {
                    case KEEP_OR_EMPTY: 
                    case EMPTY: {
                        shouldModify = false;
                        break;
                    }
                    case KEEP_OR_CLEAR: {
                        if (this.fileData == null) {
                            this.errorLock = false;
                            break;
                        }
                        shouldModify = false;
                        break;
                    }
                    case KEEP_OR_THROW: {
                        shouldModify = false;
                        if (this.fileData != null) break;
                        shouldThrow = true;
                        break;
                    }
                    case ROLLBACK: {
                        if (this.fileData == null) {
                            shouldThrow = true;
                            break;
                        }
                        out = this.fileData.toMap();
                        this.errorLock = false;
                        break;
                    }
                    case CLEAR: {
                        this.errorLock = false;
                    }
                }
            }
            if (shouldModify) {
                if (this.fileData == null) {
                    this.fileData = new FileData(out, this.dataType, this.pathSeparator());
                } else {
                    this.fileData.loadData(out);
                }
            }
            this.lastLoaded = System.currentTimeMillis();
            if (ex && this.errorConsumer != null) {
                this.errorConsumer.accept(this);
            }
            if (shouldModify && this.reloadConsumer != null) {
                this.reloadConsumer.accept(this);
            }
        }
        if (shouldThrow) {
            throw new IllegalStateException("Exception caused because of the error handler requirements: " + this.errorHandler.name() + " (" + this.errorHandler.getReason() + ")");
        }
    }

    public final void clear() {
        this.fileData.clear();
        this.write();
    }

    public final void clearPathPrefix() {
        this.pathPrefix = null;
    }

    protected final void reloadIfNeeded() {
        if (this.shouldReload()) {
            this.forceReload();
        }
    }

    protected boolean shouldReload() {
        switch (this.reloadSettings) {
            case AUTOMATICALLY: {
                return true;
            }
            case INTELLIGENT: {
                return FileUtils.hasChanged(this.file, this.lastLoaded);
            }
        }
        return false;
    }

    public final FileData getFileData() {
        Valid.notNull(this.fileData, "FileData mustn't be null");
        return this.fileData;
    }

    public final FlatFileSection getSection(String[] pathPrefix) {
        return new FlatFileSection(this, pathPrefix);
    }

    public final FlatFileSection getSection(String pathPrefix) {
        return this.getSection(this.splitPath(pathPrefix));
    }

    @Override
    public final int compareTo(@NonNull FlatFile flatFile) {
        if (flatFile == null) {
            throw new NullPointerException("flatFile is marked non-null but is null");
        }
        return this.file.compareTo(flatFile.file);
    }

    public void annotateClass(Object classInstance, String section) {
        this.annotateClass(classInstance, (String s2, Field field) -> section + "." + s2);
    }

    public void annotateClass(Object classInstance) {
        this.annotateClass(classInstance, (String s2, Field field) -> s2);
    }

    public void annotateClass(Object classInstance, BiFunction<String, Field, String> elementSelector) {
        Class<?> clazz = classInstance.getClass();
        try {
            for (Field field : clazz.getFields()) {
                ConfigPath configPath = field.getAnnotation(ConfigPath.class);
                if (configPath == null) continue;
                field.setAccessible(true);
                field.set(classInstance, this.get(elementSelector.apply(configPath.value(), field), field.getType()));
            }
        }
        catch (IllegalAccessException e) {
            throw SimplixProviders.exceptionHandler().create(e.getCause(), "Unable to set the value of fields in " + clazz.getName());
        }
    }

    @Generated
    public String toString() {
        return "FlatFile(file=" + this.getFile() + ", fileType=" + this.getFileType() + ", reloadSettings=" + this.getReloadSettings() + ", errorHandler=" + this.getErrorHandler() + ", dataType=" + this.getDataType() + ", fileData=" + this.getFileData() + ", reloadConsumer=" + this.getReloadConsumer() + ", errorConsumer=" + this.getErrorConsumer() + ", pathPrefix=" + this.getPathPrefix() + ", pathSeparator=" + this.pathSeparator + ", lastLoaded=" + this.getLastLoaded() + ", errorLock=" + this.errorLock + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlatFile)) {
            return false;
        }
        FlatFile other = (FlatFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastLoaded() != other.getLastLoaded()) {
            return false;
        }
        if (this.errorLock != other.errorLock) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        FileType this$fileType = this.getFileType();
        FileType other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !((Object)((Object)this$fileType)).equals((Object)other$fileType)) {
            return false;
        }
        ReloadSettings this$reloadSettings = this.getReloadSettings();
        ReloadSettings other$reloadSettings = other.getReloadSettings();
        if (this$reloadSettings == null ? other$reloadSettings != null : !((Object)((Object)this$reloadSettings)).equals((Object)other$reloadSettings)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !((Object)((Object)this$errorHandler)).equals((Object)other$errorHandler)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        FileData this$fileData = this.getFileData();
        FileData other$fileData = other.getFileData();
        if (this$fileData == null ? other$fileData != null : !((Object)this$fileData).equals(other$fileData)) {
            return false;
        }
        Consumer<FlatFile> this$reloadConsumer = this.getReloadConsumer();
        Consumer<FlatFile> other$reloadConsumer = other.getReloadConsumer();
        if (this$reloadConsumer == null ? other$reloadConsumer != null : !this$reloadConsumer.equals(other$reloadConsumer)) {
            return false;
        }
        Consumer<FlatFile> this$errorConsumer = this.getErrorConsumer();
        Consumer<FlatFile> other$errorConsumer = other.getErrorConsumer();
        if (this$errorConsumer == null ? other$errorConsumer != null : !this$errorConsumer.equals(other$errorConsumer)) {
            return false;
        }
        String this$pathPrefix = this.getPathPrefix();
        String other$pathPrefix = other.getPathPrefix();
        if (this$pathPrefix == null ? other$pathPrefix != null : !this$pathPrefix.equals(other$pathPrefix)) {
            return false;
        }
        String this$pathSeparator = this.pathSeparator;
        String other$pathSeparator = other.pathSeparator;
        return !(this$pathSeparator == null ? other$pathSeparator != null : !this$pathSeparator.equals(other$pathSeparator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlatFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastLoaded = this.getLastLoaded();
        result = result * 59 + (int)($lastLoaded >>> 32 ^ $lastLoaded);
        result = result * 59 + (this.errorLock ? 79 : 97);
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        FileType $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : ((Object)((Object)$fileType)).hashCode());
        ReloadSettings $reloadSettings = this.getReloadSettings();
        result = result * 59 + ($reloadSettings == null ? 43 : ((Object)((Object)$reloadSettings)).hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : ((Object)((Object)$errorHandler)).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        FileData $fileData = this.getFileData();
        result = result * 59 + ($fileData == null ? 43 : ((Object)$fileData).hashCode());
        Consumer<FlatFile> $reloadConsumer = this.getReloadConsumer();
        result = result * 59 + ($reloadConsumer == null ? 43 : $reloadConsumer.hashCode());
        Consumer<FlatFile> $errorConsumer = this.getErrorConsumer();
        result = result * 59 + ($errorConsumer == null ? 43 : $errorConsumer.hashCode());
        String $pathPrefix = this.getPathPrefix();
        result = result * 59 + ($pathPrefix == null ? 43 : $pathPrefix.hashCode());
        String $pathSeparator = this.pathSeparator;
        result = result * 59 + ($pathSeparator == null ? 43 : $pathSeparator.hashCode());
        return result;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public FileType getFileType() {
        return this.fileType;
    }

    @Generated
    public ReloadSettings getReloadSettings() {
        return this.reloadSettings;
    }

    @Generated
    public void setReloadSettings(ReloadSettings reloadSettings) {
        this.reloadSettings = reloadSettings;
    }

    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public DataType getDataType() {
        return this.dataType;
    }

    @Nullable
    @Generated
    public Consumer<FlatFile> getReloadConsumer() {
        return this.reloadConsumer;
    }

    @Nullable
    @Generated
    public Consumer<FlatFile> getErrorConsumer() {
        return this.errorConsumer;
    }

    @Generated
    public long getLastLoaded() {
        return this.lastLoaded;
    }
}

