/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.de.leonhard.storage.internal.editor.yaml;

import host.plas.bou.libs.de.leonhard.storage.util.FileUtils;
import host.plas.bou.libs.de.leonhard.storage.util.YamlUtils;
import java.io.File;
import java.util.List;
import lombok.Generated;

public class YamlEditor {
    private final File file;

    public List<String> read() {
        return FileUtils.readAllLines(this.file);
    }

    public List<String> readKeys() {
        return YamlUtils.getKeys(this.read());
    }

    public List<String> readComments() {
        return YamlUtils.getKeys(this.read());
    }

    public List<String> readHeader() {
        return YamlUtils.getHeaderFromLines(this.read());
    }

    public List<String> readFooter() {
        return YamlUtils.getFooterFromLines(this.read());
    }

    public List<String> readPureComments() {
        return YamlUtils.getPureCommentsFromLines(this.read());
    }

    public List<String> readWithoutHeaderAndFooter() {
        return YamlUtils.getLinesWithoutFooterAndHeaderFromLines(this.read());
    }

    public void write(List<String> lines) {
        FileUtils.write(this.file, lines);
    }

    public void setHeader(List<String> header) {
        List<String> lines = this.read();
        lines.removeAll(this.readHeader());
        for (int i2 = 0; i2 < header.size(); ++i2) {
            String toAdd = header.get(i2);
            lines.add(i2, (String)(toAdd.startsWith("#") ? toAdd : "#" + toAdd));
        }
        this.write(lines);
    }

    public void addHeader(List<String> header) {
        List<String> lines = this.read();
        for (int i2 = 0; i2 < header.size(); ++i2) {
            String toAdd = header.get(i2);
            lines.add(i2, (String)(toAdd.startsWith("#") ? toAdd : "#" + toAdd));
        }
        this.write(lines);
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public YamlEditor(File file) {
        this.file = file;
    }
}

