/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans;

import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.Beans;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.DeferredConstruction;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlConfig;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlException;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.YamlWriter;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.AliasEvent;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.CollectionStartEvent;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.Event;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.EventType;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.Parser;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.parser.ScalarEvent;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlReader
implements AutoCloseable {
    private final YamlConfig config;
    Parser parser;
    private final Map<String, Object> anchors = new HashMap<String, Object>();

    public YamlReader(Reader reader) {
        this(reader, new YamlConfig());
    }

    public YamlReader(Reader reader, YamlConfig config) {
        this.config = config;
        this.parser = new Parser(reader, config.readConfig.defaultVersion);
    }

    public YamlReader(String yaml) {
        this(new StringReader(yaml));
    }

    public YamlReader(String yaml, YamlConfig config) {
        this(new StringReader(yaml), config);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public Object get(String alias) {
        return this.anchors.get(alias);
    }

    private void addAnchor(String key, Object value) {
        if (this.config.readConfig.anchors) {
            this.anchors.put(key, value);
        }
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.anchors.clear();
    }

    public Object read() throws YamlException {
        return this.read(null);
    }

    public <T> T read(Class<T> type) throws YamlException {
        return this.read(type, null);
    }

    public <T> T read(Class<T> type, Class elementType) throws YamlException {
        this.anchors.clear();
        try {
            Event event;
            do {
                if ((event = this.parser.getNextEvent()) == null) {
                    return null;
                }
                if (event.type != EventType.STREAM_END) continue;
                return null;
            } while (event.type != EventType.DOCUMENT_START);
            Object object = this.readValue(type, elementType, null);
            this.parser.getNextEvent();
            return (T)object;
        }
        catch (Parser.ParserException ex) {
            throw new YamlException("Error parsing YAML.", ex);
        }
        catch (Tokenizer.TokenizerException ex) {
            throw new YamlException("Error tokenizing YAML.", ex);
        }
    }

    public <T> Iterator<T> readAll(final Class<T> type) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                Event event = YamlReader.this.parser.peekNextEvent();
                return event != null && event.type != EventType.STREAM_END;
            }

            @Override
            public T next() {
                try {
                    return YamlReader.this.read(type);
                }
                catch (YamlException ex) {
                    throw new RuntimeException("Error reading YAML document for iterator.", ex);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected Object readValue(Class type, Class elementType, Class defaultType) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        String tag = null;
        String anchor = null;
        Event event = this.parser.peekNextEvent();
        switch (event.type) {
            case ALIAS: {
                this.parser.getNextEvent();
                anchor = ((AliasEvent)event).anchor;
                Object value = this.anchors.get(anchor);
                if (value == null && this.config.readConfig.anchors) {
                    throw new YamlReaderException("Unknown anchor: " + anchor);
                }
                return value;
            }
            case MAPPING_START: 
            case SEQUENCE_START: {
                tag = ((CollectionStartEvent)event).tag;
                anchor = ((CollectionStartEvent)event).anchor;
                break;
            }
            case SCALAR: {
                tag = ((ScalarEvent)event).tag;
                anchor = ((ScalarEvent)event).anchor;
                break;
            }
        }
        return this.readValueInternal(this.chooseType(tag, defaultType, type), elementType, anchor);
    }

    private Class<?> chooseType(String tag, Class<?> defaultType, Class<?> providedType) throws YamlReaderException {
        if (tag != null && this.config.readConfig.classTags) {
            Class userConfiguredByTag = this.config.tagToClass.get(tag);
            if (userConfiguredByTag != null) {
                return userConfiguredByTag;
            }
            ClassLoader classLoader = this.config.readConfig.classLoader == null ? this.getClass().getClassLoader() : this.config.readConfig.classLoader;
            tag = tag.replace("!", "");
            try {
                Class<?> loadedFromTag = this.findTagClass(tag, classLoader);
                if (loadedFromTag != null) {
                    if (providedType != null && !providedType.isAssignableFrom(loadedFromTag)) {
                        throw new YamlReaderException("Class specified by tag is incompatible with expected type: " + loadedFromTag.getName() + " (expected " + providedType.getName() + ")");
                    }
                    return loadedFromTag;
                }
            }
            catch (ClassNotFoundException e) {
                throw new YamlReaderException("Unable to find class specified by tag: " + tag);
            }
        }
        if (defaultType != null) {
            return defaultType;
        }
        return providedType;
    }

    protected Class<?> findTagClass(String tag, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(tag, true, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private Object readValueInternal(Class type, Class elementType, String anchor) throws YamlException, Parser.ParserException, Tokenizer.TokenizerException {
        Object event;
        if (type == null || type == Object.class) {
            event = this.parser.peekNextEvent();
            switch (((Event)event).type) {
                case MAPPING_START: {
                    type = LinkedHashMap.class;
                    break;
                }
                case SCALAR: {
                    Number number;
                    String string;
                    if (this.config.readConfig.guessNumberTypes && (string = ((ScalarEvent)event).value) != null && (number = this.valueConvertedNumber(string)) != null) {
                        if (anchor != null) {
                            this.addAnchor(anchor, number);
                        }
                        this.parser.getNextEvent();
                        return number;
                    }
                    type = String.class;
                    break;
                }
                case SEQUENCE_START: {
                    type = ArrayList.class;
                    break;
                }
                default: {
                    throw new YamlReaderException("Expected scalar, sequence, or mapping but found: " + (Object)((Object)((Event)event).type));
                }
            }
        }
        if (Beans.isScalar(type)) {
            event = this.parser.getNextEvent();
            if (((Event)event).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for primitive type '" + type.getClass() + "' but found: " + (Object)((Object)((Event)event).type));
            }
            String string = ((ScalarEvent)event).value;
            try {
                Object convertedValue;
                if (string == null) {
                    convertedValue = null;
                } else if (type == String.class) {
                    convertedValue = string;
                } else if (type == Integer.TYPE || type == Integer.class) {
                    convertedValue = Integer.decode(string);
                } else if (type == Boolean.TYPE || type == Boolean.class) {
                    convertedValue = Boolean.valueOf(string);
                } else if (type == Float.TYPE || type == Float.class) {
                    convertedValue = Float.valueOf(string);
                } else if (type == Double.TYPE || type == Double.class) {
                    convertedValue = Double.valueOf(string);
                } else if (type == Long.TYPE || type == Long.class) {
                    convertedValue = Long.decode(string);
                } else if (type == Short.TYPE || type == Short.class) {
                    convertedValue = Short.decode(string);
                } else if (type == Character.TYPE || type == Character.class) {
                    convertedValue = Character.valueOf(string.charAt(0));
                } else if (type == Byte.TYPE || type == Byte.class) {
                    convertedValue = Byte.decode(string);
                } else {
                    throw new YamlException("Unknown field type.");
                }
                if (anchor != null) {
                    this.addAnchor(anchor, convertedValue);
                }
                return convertedValue;
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to convert value to required type \"" + type + "\": " + string, ex);
            }
        }
        for (Map.Entry entry : this.config.scalarSerializers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(type)) continue;
            ScalarSerializer serializer = (ScalarSerializer)entry.getValue();
            Event event2 = this.parser.getNextEvent();
            if (event2.type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for type '" + type + "' to be deserialized by scalar serializer '" + serializer.getClass().getName() + "' but found: " + (Object)((Object)event2.type));
            }
            Object value2 = serializer.read(((ScalarEvent)event2).value);
            if (anchor != null) {
                this.addAnchor(anchor, value2);
            }
            return value2;
        }
        if (Enum.class.isAssignableFrom(type)) {
            event = this.parser.getNextEvent();
            if (((Event)event).type != EventType.SCALAR) {
                throw new YamlReaderException("Expected scalar for enum type but found: " + (Object)((Object)((Event)event).type));
            }
            String string = ((ScalarEvent)event).value;
            if (string == null) {
                return null;
            }
            try {
                return Enum.valueOf(type, string);
            }
            catch (Exception ex) {
                throw new YamlReaderException("Unable to find enum value '" + string + "' for enum class: " + type.getName());
            }
        }
        event = this.parser.peekNextEvent();
        switch (((Event)event).type) {
            case MAPPING_START: {
                void var5_12;
                Object object;
                event = this.parser.getNextEvent();
                try {
                    object = this.createObject(type);
                }
                catch (InvocationTargetException ex) {
                    throw new YamlReaderException("Error creating object.", ex);
                }
                if (anchor != null) {
                    this.addAnchor(anchor, object);
                }
                ArrayList<Object> keys = new ArrayList<Object>();
                while (true) {
                    if (this.parser.peekNextEvent().type == EventType.MAPPING_END) break;
                    Object key = this.readValue(null, null, null);
                    boolean isExplicitKey = key instanceof Map;
                    Object var9_29 = null;
                    if (isExplicitKey) {
                        Map.Entry nameValuePair = ((Map)key).entrySet().iterator().next();
                        key = nameValuePair.getKey();
                        Object v = nameValuePair.getValue();
                    }
                    if (object instanceof Map) {
                        void var9_33;
                        if (this.config.tagSuffix != null) {
                            Event nextEvent = this.parser.peekNextEvent();
                            switch (nextEvent.type) {
                                case MAPPING_START: 
                                case SEQUENCE_START: {
                                    ((Map)object).put(key + this.config.tagSuffix, ((CollectionStartEvent)nextEvent).tag);
                                    break;
                                }
                                case SCALAR: {
                                    ((Map)object).put(key + this.config.tagSuffix, ((ScalarEvent)nextEvent).tag);
                                }
                            }
                        }
                        if (!isExplicitKey) {
                            Object object2 = this.readValue(elementType, null, null);
                        }
                        if (!this.config.allowDuplicates && ((Map)object).containsKey(key)) {
                            throw new YamlReaderException("Duplicate key found '" + key + "'");
                        }
                        if (this.config.readConfig.autoMerge && "<<".equals(key) && var9_33 != null) {
                            this.mergeMap((Map)object, var9_33);
                            continue;
                        }
                        ((Map)object).put(key, var9_33);
                        continue;
                    }
                    try {
                        void var9_35;
                        if (!this.config.allowDuplicates && keys.contains(key)) {
                            throw new YamlReaderException("Duplicate key found '" + key + "'");
                        }
                        keys.add(key);
                        Beans.Property property = Beans.getProperty(type, (String)key, this.config.beanProperties, this.config.privateFields, this.config);
                        if (property == null) {
                            if (this.config.readConfig.ignoreUnknownProperties) {
                                Event nextEvent = this.parser.peekNextEvent();
                                EventType nextType = nextEvent.type;
                                if (nextType == EventType.SEQUENCE_START || nextType == EventType.MAPPING_START) {
                                    this.skipRange();
                                    continue;
                                }
                                this.parser.getNextEvent();
                                continue;
                            }
                            throw new YamlReaderException("Unable to find property '" + key + "' on class: " + type.getName());
                        }
                        Class propertyElementType = this.config.propertyToElementType.get(property);
                        if (propertyElementType == null) {
                            propertyElementType = property.getElementType();
                        }
                        Class propertyDefaultType = this.config.propertyToDefaultType.get(property);
                        if (!isExplicitKey) {
                            Object object3 = this.readValue(property.getType(), propertyElementType, propertyDefaultType);
                        }
                        property.set(object, var9_35);
                    }
                    catch (Exception ex) {
                        if (ex instanceof YamlReaderException) {
                            throw (YamlReaderException)ex;
                        }
                        throw new YamlReaderException("Error setting property '" + key + "' on class: " + type.getName(), ex);
                    }
                }
                this.parser.getNextEvent();
                if (object instanceof DeferredConstruction) {
                    try {
                        Object object4 = ((DeferredConstruction)object).construct();
                        if (anchor != null) {
                            this.addAnchor(anchor, object4);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                }
                return var5_12;
            }
            case SEQUENCE_START: {
                void var5_15;
                event = this.parser.getNextEvent();
                if (Collection.class.isAssignableFrom(type)) {
                    try {
                        Collection collection = (Collection)Beans.createObject(type, this.config.privateConstructors);
                    }
                    catch (InvocationTargetException ex) {
                        throw new YamlReaderException("Error creating object.", ex);
                    }
                } else if (type.isArray()) {
                    ArrayList arrayList = new ArrayList();
                    elementType = type.getComponentType();
                } else {
                    throw new YamlReaderException("A sequence is not a valid value for the type: " + type.getName());
                }
                if (!type.isArray() && anchor != null) {
                    this.addAnchor(anchor, var5_15);
                }
                while (true) {
                    event = this.parser.peekNextEvent();
                    if (((Event)event).type == EventType.SEQUENCE_END) break;
                    var5_15.add(this.readValue(elementType, null, null));
                }
                this.parser.getNextEvent();
                if (!type.isArray()) {
                    return var5_15;
                }
                Object array = Array.newInstance(elementType, var5_15.size());
                int i2 = 0;
                for (Object e : var5_15) {
                    Array.set(array, i2++, e);
                }
                if (anchor != null) {
                    this.addAnchor(anchor, array);
                }
                return array;
            }
        }
        throw new YamlReaderException("Expected data for a " + type.getName() + " field but found: " + (Object)((Object)((Event)event).type));
    }

    private void mergeMap(Map<String, Object> dest, Object source) throws YamlReaderException {
        if (source instanceof Collection) {
            for (Object item : (Collection)source) {
                this.mergeMap(dest, item);
            }
        } else if (source instanceof Map) {
            Map map = (Map)source;
            for (Map.Entry entry : map.entrySet()) {
                if (dest.containsKey(entry.getKey())) continue;
                dest.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            throw new YamlReaderException("Expected a mapping or a sequence of mappings for a '<<' merge field but found: " + source.getClass().getSimpleName());
        }
    }

    protected Object createObject(Class type) throws InvocationTargetException {
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, this.config);
        if (deferredConstruction != null) {
            return deferredConstruction;
        }
        return Beans.createObject(type, this.config.privateConstructors);
    }

    private Number valueConvertedNumber(String value) {
        Number number = null;
        try {
            number = Long.decode(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number == null) {
            try {
                number = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    private void skipRange() {
        int depth = 0;
        do {
            Event nextEvent = this.parser.getNextEvent();
            switch (nextEvent.type) {
                case SEQUENCE_START: {
                    ++depth;
                    break;
                }
                case MAPPING_START: {
                    ++depth;
                    break;
                }
                case SEQUENCE_END: {
                    --depth;
                    break;
                }
                case MAPPING_END: {
                    --depth;
                    break;
                }
            }
        } while (depth > 0);
    }

    public static void main(String[] args) throws Exception {
        YamlReader reader = new YamlReader(new FileReader("test/test.yml"));
        Object object = reader.read();
        System.out.println(object);
        StringWriter string = new StringWriter();
        YamlWriter writer = new YamlWriter(string);
        writer.write(object);
        writer.close();
        System.out.println(string);
    }

    public class YamlReaderException
    extends YamlException {
        public YamlReaderException(String message, Throwable cause) {
            super("Line " + YamlReader.this.parser.getLineNumber() + ", column " + YamlReader.this.parser.getColumn() + ": " + message, cause);
        }

        public YamlReaderException(String message) {
            this(message, null);
        }
    }
}

