/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.de.leonhard.storage.shaded.esotericsoftware.yamlbeans.scalar;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

class DateTimeParser
extends DateFormat {
    private static final String DATEFORMAT_YAML = "yyyy-MM-dd HH:mm:ss";
    private static final int FORMAT_NONE = -1;
    private SimpleDateFormat outputFormat;
    private ArrayList<Parser> parsers = new ArrayList();

    public DateTimeParser() {
        this.outputFormat = new SimpleDateFormat(DATEFORMAT_YAML);
        this.parsers.add(new SimpleParser(this.outputFormat));
        this.parsers.add(new Parser(){

            public Date parse(String s2) throws ParseException {
                try {
                    long val = Long.parseLong(s2);
                    return new Date(val);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Error parsing value", -1);
                }
            }
        });
        this.parsers.add(new SimpleParser("yyyy-MM-dd"));
        this.parsers.add(new SimpleParser(0, 0));
        this.parsers.add(new SimpleParser(1, 1));
        this.parsers.add(new SimpleParser(2, 2));
        this.parsers.add(new SimpleParser(3, 3));
        this.parsers.add(new SimpleParser(0, -1));
        this.parsers.add(new SimpleParser(1, -1));
        this.parsers.add(new SimpleParser(2, -1));
        this.parsers.add(new SimpleParser(3, -1));
        this.parsers.add(new SimpleParser(-1, 0));
        this.parsers.add(new SimpleParser(-1, 1));
        this.parsers.add(new SimpleParser(-1, 2));
        this.parsers.add(new SimpleParser(-1, 3));
    }

    public Date parse(String text, ParsePosition pos) {
        String s2 = text.substring(pos.getIndex());
        Date date = null;
        for (Parser parser : this.parsers) {
            try {
                date = parser.parse(s2);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (date == null) {
            pos.setIndex(pos.getIndex());
            pos.setErrorIndex(pos.getIndex());
        } else {
            pos.setIndex(s2.length());
        }
        return date;
    }

    public StringBuffer format(Date date, StringBuffer buf, FieldPosition pos) {
        return this.outputFormat.format(date, buf, pos);
    }

    protected static class SimpleParser
    implements Parser {
        private DateFormat format;

        public SimpleParser(String format) {
            this.format = new SimpleDateFormat(format);
        }

        public SimpleParser(DateFormat format) {
            this.format = format;
        }

        public SimpleParser(int dateType, int timeType) {
            this.format = timeType < 0 ? DateFormat.getDateInstance(dateType) : (dateType < 0 ? DateFormat.getTimeInstance(timeType) : DateFormat.getDateTimeInstance(dateType, timeType));
        }

        public Date parse(String s2) throws ParseException {
            return this.format.parse(s2);
        }
    }

    protected static interface Parser {
        public Date parse(String var1) throws ParseException;
    }
}

