/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.de.leonhard.storage.util;

import host.plas.bou.libs.de.leonhard.storage.internal.provider.SimplixProviders;
import host.plas.bou.libs.de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import host.plas.bou.libs.de.leonhard.storage.util.Valid;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import lombok.NonNull;

public final class FileUtils {
    public static List<File> listFiles(@NonNull File folder) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        return FileUtils.listFiles(folder, null);
    }

    public static List<File> listFiles(@NonNull File folder, @Nullable String extension) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] files = folder.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (extension != null && !file.getName().endsWith(extension)) continue;
            result.add(file);
        }
        return result;
    }

    public static File getAndMake(@NonNull String name, @NonNull String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return FileUtils.getAndMake(new File(path, name));
    }

    public static File getAndMake(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while creating file '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
        return file;
    }

    private static String getExtension(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return path.lastIndexOf(".") > 0 ? path.substring(path.lastIndexOf(".") + 1) : "";
    }

    public static String getExtension(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FileUtils.getExtension(file.getName());
    }

    public static String replaceExtensions(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (!fileName.contains(".")) {
            return fileName;
        }
        return fileName.replace("." + FileUtils.getExtension(fileName), "");
    }

    public static String getParentDirPath(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FileUtils.getParentDirPath(file.getAbsolutePath());
    }

    private static String getParentDirPath(@NonNull String fileOrDirPath) {
        if (fileOrDirPath == null) {
            throw new NullPointerException("fileOrDirPath is marked non-null but is null");
        }
        boolean endsWithSlash = fileOrDirPath.endsWith(File.separator);
        return fileOrDirPath.substring(0, fileOrDirPath.lastIndexOf(File.separatorChar, endsWithSlash ? fileOrDirPath.length() - 2 : fileOrDirPath.length() - 1));
    }

    public static boolean hasChanged(File file, long timeStamp) {
        if (file == null) {
            return false;
        }
        return timeStamp < file.lastModified();
    }

    public static InputStream createInputStream(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while creating InputStream from '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    private static OutputStream createOutputStream(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while creating OutputStream from '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    public static Reader createReader(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while creating Reader for '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    public static Writer createWriter(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while creating Writer for '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    public static void write(@NonNull File file, @NonNull List<String> lines) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        try {
            Files.write(file.toPath(), lines, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while writing to '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    public static boolean writeToFile(@NonNull File file, @NonNull InputStream inputStream) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        return FileUtils.writeToFile(file, inputStream, false);
    }

    public static boolean writeToFile(@NonNull File file, @NonNull InputStream inputStream, boolean avoidExists) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        boolean exists = false;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            if (!file.exists()) {
                Files.copy(inputStream, file.toPath(), new CopyOption[0]);
            } else {
                exists = true;
                if (!avoidExists) {
                    int count;
                    byte[] data = new byte[8192];
                    while ((count = inputStream.read(data, 0, 8192)) != -1) {
                        outputStream.write(data, 0, count);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while writing InputStream to '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
        return exists;
    }

    private static byte[] readAllBytes(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException ex) {
            throw SimplixProviders.exceptionHandler().create(ex, "Error while reading '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
        }
    }

    public static List<String> readAllLines(@NonNull File file) {
        List<String> list;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        byte[] fileBytes = FileUtils.readAllBytes(file);
        String asString = new String(fileBytes);
        BufferedReader reader = new BufferedReader(new StringReader(asString));
        try {
            list = reader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw SimplixProviders.exceptionHandler().create(ex, "Error while reading '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
            }
        }
        reader.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(String sourceDirectory, String to) {
        File fileTo = FileUtils.getAndMake(new File(to + ".zip"));
        ZipOutputStream zipOutputStream = new ZipOutputStream(FileUtils.createOutputStream(fileTo));
        try {
            Path pathFrom = Paths.get(new File(sourceDirectory).toURI());
            try (Stream<Path> walk = Files.walk(pathFrom, new FileVisitOption[0]);){
                walk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(pathFrom.relativize((Path)path).toString());
                    try {
                        zipOutputStream.putNextEntry(zipEntry);
                        Files.copy(path, zipOutputStream);
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException ex) {
                        SimplixProviders.logger().printStackTrace(ex);
                    }
                });
            }
        }
        finally {
            if (Collections.singletonList(zipOutputStream).get(0) != null) {
                zipOutputStream.close();
            }
        }
    }

    public static String md5ChecksumAsString(@NonNull File filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        byte[] checkSum = FileUtils.md5Checksum(filename);
        StringBuilder result = new StringBuilder();
        for (byte b : checkSum) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private static byte[] md5Checksum(@NonNull File file) {
        byte[] byArray;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = fileInputStream.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byArray = complete.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                throw SimplixProviders.exceptionHandler().create(ex, "Error while creating checksum of '" + file.getName() + "'.", "In: '" + FileUtils.getParentDirPath(file) + "'");
            }
        }
        fileInputStream.close();
        return byArray;
    }

    public static void extractResource(@NonNull String targetDirectory, @NonNull String resourcePath, boolean replace) {
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked non-null but is null");
        }
        Valid.checkBoolean(!resourcePath.isEmpty(), "ResourcePath mustn't be empty");
        Valid.checkBoolean(!targetDirectory.isEmpty(), "Target directory mustn't be empty");
        File target = new File(targetDirectory, resourcePath);
        if (target.exists() && !replace) {
            return;
        }
        FileUtils.getAndMake(target);
        try (InputStream inputStream = SimplixProviders.inputStreamProvider().createInputStreamFromInnerResource(resourcePath);){
            Valid.notNull(inputStream, "The embedded resource '" + resourcePath + "' cannot be found");
            Files.copy(Objects.requireNonNull(inputStream), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioException) {
            throw SimplixProviders.exceptionHandler().create(ioException, "Exception while extracting file", "Directory: '" + targetDirectory + "'", "ResourcePath: '" + resourcePath + "'");
        }
    }

    public static void extractResourceFolderContents(@NonNull File sourceJarFile, @NonNull File targetDirectory, @NonNull String sourceDirectory, boolean replace) {
        if (sourceJarFile == null) {
            throw new NullPointerException("sourceJarFile is marked non-null but is null");
        }
        if (targetDirectory == null) {
            throw new NullPointerException("targetDirectory is marked non-null but is null");
        }
        if (sourceDirectory == null) {
            throw new NullPointerException("sourceDirectory is marked non-null but is null");
        }
        if (!targetDirectory.exists()) {
            Valid.checkBoolean(targetDirectory.mkdirs(), "Can't create directory '" + targetDirectory.getName() + "'", "Parent: '" + FileUtils.getParentDirPath(targetDirectory) + "'");
        }
        Valid.checkBoolean(targetDirectory.isDirectory(), "Target directory must be an directory");
        try (JarFile jarFile = new JarFile(sourceJarFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.startsWith(sourceDirectory) || jarEntry.isDirectory()) continue;
                FileUtils.extractResource(targetDirectory.getAbsolutePath(), entryName, replace);
            }
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Failed to extract folder from '" + targetDirectory + "' to '" + sourceDirectory + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFolder(@NonNull File source, @NonNull File destination) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if ((files = source.list()) == null) {
                return;
            }
            for (String file : files) {
                File srcFile = new File(source, file);
                File destFile = new File(destination, file);
                FileUtils.copyFolder(srcFile, destFile);
            }
        } else {
            InputStream in = FileUtils.createInputStream(source);
            try {
                OutputStream out = FileUtils.createOutputStream(destination);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = in.read(buffer)) > 0) {
                        out.write(buffer, 0, length);
                    }
                }
                finally {
                    if (Collections.singletonList(out).get(0) != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

