/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.gson.internal.bind;

import host.plas.bou.libs.gson.Gson;
import host.plas.bou.libs.gson.JsonSyntaxException;
import host.plas.bou.libs.gson.TypeAdapter;
import host.plas.bou.libs.gson.TypeAdapterFactory;
import host.plas.bou.libs.gson.reflect.TypeToken;
import host.plas.bou.libs.gson.stream.JsonReader;
import host.plas.bou.libs.gson.stream.JsonToken;
import host.plas.bou.libs.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TimeTypeAdapter
extends TypeAdapter<Time> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new TimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

