/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.math;

import java.util.Random;

public class CosmicMath {
    public static double getDistance3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(CosmicMath.getDistance3DSquared(x1, y1, z1, x2, y2, z2));
    }

    public static double getDistance3DSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistance2D(double x1, double z1, double x2, double z2) {
        return Math.sqrt(CosmicMath.getDistance2DSquared(x1, z1, x2, z2));
    }

    public static double getDistance2DSquared(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static Random getNewRandom() {
        return new Random();
    }

    public static int getRandomInt(int min2, int max) {
        return min2 + CosmicMath.getNewRandom().nextInt(max - min2 + 1);
    }

    public static double getRandomDouble(double min2, double max) {
        return min2 + CosmicMath.getNewRandom().nextDouble() * (max - min2);
    }

    public static double getRandomGaussian(double mean, double stdDev) {
        return mean + CosmicMath.getNewRandom().nextGaussian() * stdDev;
    }

    public static float getRandomFloat(float min2, float max) {
        return min2 + CosmicMath.getNewRandom().nextFloat() * (max - min2);
    }

    public static boolean getRandomBoolean() {
        return CosmicMath.getNewRandom().nextBoolean();
    }

    public static long getRandomLong(long min2, long max) {
        return min2 + CosmicMath.getNewRandom().nextLong() * (max - min2);
    }

    public static double getAngle2D(double x1, double z1, double x2, double z2) {
        return Math.atan2(z2 - z1, x2 - x1);
    }

    public static double getAngle3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.atan2(Math.sqrt(dx * dx + dz * dz), dy);
    }

    public static int ceilDiv(int x, int y) {
        return -Math.floorDiv(-x, y);
    }

    public static long ceilDiv(long x, long y) {
        return -Math.floorDiv(-x, y);
    }
}

