/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.scheduling;

import gg.drak.thebase.async.AsyncUtils;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.scheduling.TaskManager;
import host.plas.bou.utils.MessageUtils;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.Timer;

public abstract class BaseRunnable
implements Runnable {
    private Date startedAt = new Date();
    private long currentTickCount;
    private long period;
    private int index;
    private boolean paused;
    private long ticksLived;
    private Timer timer;

    public BaseRunnable(long delay, long period) {
        this.currentTickCount = delay * -1L;
        this.period = period;
        this.index = TaskManager.getNextIndex();
        this.paused = false;
        this.ticksLived = 0L;
        this.timer = this.createTimer();
        TaskManager.start(this);
    }

    public BaseRunnable(long period) {
        this(0L, period);
    }

    public void load() {
        TaskManager.load(this);
    }

    public void unload() {
        TaskManager.unload(this);
    }

    public void start() {
        if (this.timer.isRunning()) {
            return;
        }
        this.timer.start();
    }

    public void stop() {
        if (!this.timer.isRunning()) {
            return;
        }
        this.timer.stop();
    }

    public void restart() {
        this.timer.restart();
    }

    public Timer createTimer() {
        return new Timer(BaseManager.getBaseConfig().getTickingFrequency(), e -> {
            try {
                this.tick();
            }
            catch (Throwable t2) {
                MessageUtils.logDebug("Error while ticking runnable: " + String.valueOf(this), t2);
            }
        });
    }

    public CompletableFuture<Void> tick() {
        if (this.paused) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.currentTickCount >= this.period) {
            this.currentTickCount = 0L;
            try {
                future = AsyncUtils.executeAsync(this);
            }
            catch (Throwable e) {
                MessageUtils.logDebug("Error while ticking runnable: " + String.valueOf(this), e);
            }
        }
        this.countTicks();
        return future;
    }

    public void countTicks() {
        ++this.currentTickCount;
        ++this.ticksLived;
    }

    public void cancel() {
        TaskManager.cancel(this);
    }

    public boolean isCancelled() {
        return !TaskManager.getCurrentRunnables().containsKey(this.index);
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public String toString() {
        return "BaseRunnable{startedAt=" + String.valueOf(this.startedAt) + ", currentTickCount=" + this.currentTickCount + ", period=" + this.period + ", index=" + this.index + ", paused=" + this.paused + "}";
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public void setCurrentTickCount(long currentTickCount) {
        this.currentTickCount = currentTickCount;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setTicksLived(long ticksLived) {
        this.ticksLived = ticksLived;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public long getCurrentTickCount() {
        return this.currentTickCount;
    }

    public long getPeriod() {
        return this.period;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getTicksLived() {
        return this.ticksLived;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

