/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.scheduling;

import host.plas.bou.libs.universalScheduler.scheduling.tasks.MyScheduledTask;
import host.plas.bou.scheduling.InjectedRunnable;
import host.plas.bou.scheduling.TaskAnswer;
import host.plas.bou.scheduling.TaskManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class CompletableTask {
    private MyScheduledTask task;
    private InjectedRunnable injectedRunnable;
    private boolean cancelled;
    private CompletableFuture<Void> future;
    private ConcurrentSkipListMap<Integer, Runnable> completionRunnables;

    public CompletableTask(MyScheduledTask task, InjectedRunnable injectedRunnable) {
        this.task = task;
        this.injectedRunnable = injectedRunnable;
        this.cancelled = false;
        this.completionRunnables = new ConcurrentSkipListMap();
        this.future = CompletableFuture.runAsync(() -> {
            boolean invalid;
            boolean bl = invalid = !this.isTaskValid();
            while (!(this.isDone() || this.isCancelled() || this.isTaskCompleted() || invalid)) {
                if (!this.isTaskValid()) {
                    invalid = true;
                    break;
                }
                Thread.onSpinWait();
            }
            if (invalid) {
                this.cancel();
                return;
            }
            if (this.isCancelled()) {
                this.cancel();
            }
            this.runCompletion();
        });
    }

    public CompletableTask(InjectedRunnable runnable) {
        this(TaskManager.getScheduler().runTask(runnable), runnable);
    }

    public CompletableTask(InjectedRunnable runnable, long delay) {
        this(TaskManager.getScheduler().runTaskLater(runnable, delay), runnable);
    }

    public CompletableTask(InjectedRunnable runnable, long delay, long period) {
        this(TaskManager.getScheduler().runTaskTimer(runnable, delay, period), runnable);
    }

    public CompletableTask(Entity entity, InjectedRunnable runnable) {
        this(TaskManager.getScheduler().runTask(entity, (Runnable)runnable), runnable);
    }

    public CompletableTask(Entity entity, InjectedRunnable runnable, long delay) {
        this(TaskManager.getScheduler().runTaskLater(entity, (Runnable)runnable, delay), runnable);
    }

    public CompletableTask(Entity entity, InjectedRunnable runnable, long delay, long period) {
        this(TaskManager.getScheduler().runTaskTimer(entity, (Runnable)runnable, delay, period), runnable);
    }

    public CompletableTask(World world, int x, int z, InjectedRunnable runnable) {
        this(TaskManager.getScheduler().runTask(world, x, z, runnable), runnable);
    }

    public CompletableTask(Chunk chunk, InjectedRunnable runnable) {
        this(TaskManager.getScheduler().runTask(chunk.getWorld(), chunk.getX(), chunk.getZ(), runnable), runnable);
    }

    public CompletableTask(World world, int x, int z, InjectedRunnable runnable, long delay) {
        this(TaskManager.getScheduler().runTaskLater(world, x, z, runnable, delay), runnable);
    }

    public CompletableTask(Chunk chunk, InjectedRunnable runnable, long delay) {
        this(TaskManager.getScheduler().runTaskLater(chunk.getWorld(), chunk.getX(), chunk.getZ(), runnable, delay), runnable);
    }

    public CompletableTask(World world, int x, int z, InjectedRunnable runnable, long delay, long period) {
        this(TaskManager.getScheduler().runTaskTimer(world, x, z, runnable, delay, period), runnable);
    }

    public CompletableTask(Chunk chunk, InjectedRunnable runnable, long delay, long period) {
        this(TaskManager.getScheduler().runTaskTimer(chunk.getWorld(), chunk.getX(), chunk.getZ(), runnable, delay, period), runnable);
    }

    public CompletableTask(Entity entityToTeleport, Location location) {
        this(TaskManager.getScheduler().teleport(entityToTeleport, location), new InjectedRunnable(() -> {}));
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.cancelled = true;
        this.completionRunnables.clear();
        this.complete();
    }

    public boolean isDone() {
        return this.injectedRunnable.isDone();
    }

    public InjectedRunnable complete(TaskAnswer answer) {
        return this.getInjectedRunnable().setAnswer(answer);
    }

    public InjectedRunnable complete() {
        return this.complete(TaskAnswer.REJECTED);
    }

    public void runCompletion() {
        this.getCompletionRunnables().forEach((priority, runnable) -> runnable.run());
    }

    public CompletableTask whenComplete(Runnable runnable) {
        this.getCompletionRunnables().put(this.getCompletionRunnables().size(), runnable);
        return this;
    }

    public boolean isTaskCompleted() {
        if (this.isTaskValid()) {
            if (this.task.isCancelled()) {
                this.cancel();
                return true;
            }
            return !this.task.isCurrentlyRunning();
        }
        return false;
    }

    public boolean isTaskValid() {
        return this.task != null;
    }

    public static CompletableTask of(Runnable runnable) {
        return new CompletableTask(new InjectedRunnable(runnable));
    }

    public static CompletableTask of(Runnable runnable, long delay) {
        return new CompletableTask(new InjectedRunnable(runnable), delay);
    }

    public static CompletableTask of(Runnable runnable, long delay, long period) {
        return new CompletableTask(new InjectedRunnable(runnable), delay, period);
    }

    public static CompletableTask of(Entity entity, Runnable runnable) {
        return new CompletableTask(entity, new InjectedRunnable(runnable));
    }

    public static CompletableTask of(Entity entity, Runnable runnable, long delay) {
        return new CompletableTask(entity, new InjectedRunnable(runnable), delay);
    }

    public static CompletableTask of(Entity entity, Runnable runnable, long delay, long period) {
        return new CompletableTask(entity, new InjectedRunnable(runnable), delay, period);
    }

    public static CompletableTask of(World world, int x, int z, Runnable runnable) {
        return new CompletableTask(world, x, z, new InjectedRunnable(runnable));
    }

    public static CompletableTask of(Chunk chunk, Runnable runnable) {
        return new CompletableTask(chunk, new InjectedRunnable(runnable));
    }

    public static CompletableTask of(World world, int x, int z, Runnable runnable, long delay) {
        return new CompletableTask(world, x, z, new InjectedRunnable(runnable), delay);
    }

    public static CompletableTask of(Chunk chunk, Runnable runnable, long delay) {
        return new CompletableTask(chunk, new InjectedRunnable(runnable), delay);
    }

    public static CompletableTask of(World world, int x, int z, Runnable runnable, long delay, long period) {
        return new CompletableTask(world, x, z, new InjectedRunnable(runnable), delay, period);
    }

    public static CompletableTask of(Chunk chunk, Runnable runnable, long delay, long period) {
        return new CompletableTask(chunk, new InjectedRunnable(runnable), delay, period);
    }

    public static CompletableTask of(Entity entityToTeleport, Location location) {
        return new CompletableTask(entityToTeleport, location);
    }

    public MyScheduledTask getTask() {
        return this.task;
    }

    public InjectedRunnable getInjectedRunnable() {
        return this.injectedRunnable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public ConcurrentSkipListMap<Integer, Runnable> getCompletionRunnables() {
        return this.completionRunnables;
    }

    public void setTask(MyScheduledTask task) {
        this.task = task;
    }

    public void setInjectedRunnable(InjectedRunnable injectedRunnable) {
        this.injectedRunnable = injectedRunnable;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setFuture(CompletableFuture<Void> future) {
        this.future = future;
    }

    public void setCompletionRunnables(ConcurrentSkipListMap<Integer, Runnable> completionRunnables) {
        this.completionRunnables = completionRunnables;
    }
}

