/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.scheduling;

import host.plas.bou.scheduling.TaskAnswer;
import java.util.concurrent.atomic.AtomicReference;

public class InjectedRunnable
implements Runnable {
    private Runnable runnable;
    private AtomicReference<TaskAnswer> injected;

    public InjectedRunnable(Runnable runnable, AtomicReference<TaskAnswer> injected) {
        this.runnable = runnable;
        this.injected = injected;
    }

    public InjectedRunnable(Runnable runnable) {
        this(runnable, new AtomicReference<TaskAnswer>(TaskAnswer.RUNNING));
    }

    @Override
    public void run() {
        try {
            this.runnable.run();
            this.injected.set(TaskAnswer.ACCEPTED);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.injected.set(TaskAnswer.ERROR);
        }
    }

    public TaskAnswer getInjectedNow() {
        return this.injected.get();
    }

    public boolean isDone() {
        return this.injected.get().isDone();
    }

    public InjectedRunnable setAnswer(TaskAnswer answer) {
        this.injected.set(answer);
        return this;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public AtomicReference<TaskAnswer> getInjected() {
        return this.injected;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public void setInjected(AtomicReference<TaskAnswer> injected) {
        this.injected = injected;
    }
}

