/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import host.plas.bou.BetterPlugin;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.sql.ConnectorSet;
import host.plas.bou.sql.DBAction;
import host.plas.bou.sql.DatabaseType;
import host.plas.bou.sql.ExecutionResult;
import host.plas.bou.utils.DatabaseUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class DBOperator
implements Comparable<DBOperator> {
    public static final long COOLDOWN_MILLIS = 2000L;
    private long id;
    private ConnectorSet connectorSet;
    private HikariDataSource dataSource;
    private BetterPlugin pluginUser;
    private Connection rawConnection;
    private ConcurrentSkipListMap<String, String> alterMap;
    private boolean usable;
    private Date lastConnection;

    public DBOperator(ConnectorSet connectorSet, BetterPlugin pluginUser) {
        this.id = DatabaseUtils.getNextId(pluginUser);
        this.connectorSet = connectorSet;
        this.pluginUser = pluginUser;
        this.alterMap = new ConcurrentSkipListMap();
        this.usable = false;
        this.dataSource = this.buildDataSource();
        this.register();
    }

    public void register() {
        DatabaseUtils.put(this.getPluginUser(), this);
    }

    public void unregister() {
        DatabaseUtils.remove(this.getPluginUser(), this);
    }

    public boolean isRegistered() {
        return DatabaseUtils.has(this.getPluginUser(), this);
    }

    public String getIdentifier() {
        return this.pluginUser.getIdentifier() + " - " + this.id;
    }

    public HikariDataSource buildDataSource() {
        HikariConfig config = new HikariConfig();
        switch (this.connectorSet.getType()) {
            case MYSQL: {
                Object mysqlJdbcUrl = this.connectorSet.getUri();
                mysqlJdbcUrl = !((String)mysqlJdbcUrl).contains("?") ? (String)mysqlJdbcUrl + "?autoReconnect=true" : (String)mysqlJdbcUrl + "&autoReconnect=true";
                config.setJdbcUrl((String)mysqlJdbcUrl);
                config.setUsername(this.connectorSet.getUsername());
                config.setPassword(this.connectorSet.getPassword());
                break;
            }
            case SQLITE: {
                config.setJdbcUrl(this.connectorSet.getUri() + this.getDatabaseFolder().getPath() + File.separator + this.connectorSet.getSqliteFileName());
            }
        }
        config.setPoolName(this.getIdentifier() + " - Pool");
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMaxLifetime(1800000L);
        config.setDriverClassName(this.connectorSet.getType().getDriver());
        config.setConnectionTestQuery("SELECT 1");
        this.dataSource = new HikariDataSource(config);
        this.setUsable();
        return this.dataSource;
    }

    public void updateLastConnection() {
        this.lastConnection = new Date();
    }

    public Connection getConnection(Date qStart) {
        try {
            if (this.dataSource == null) {
                this.dataSource = this.buildDataSource();
            }
            if (this.rawConnection != null && !this.rawConnection.isClosed()) {
                this.updateLastConnection();
                return this.rawConnection;
            }
            this.rawConnection = this.dataSource.getConnection();
            this.updateLastConnection();
            return this.rawConnection;
        }
        catch (Exception e) {
            this.getPluginUser().logSevereWithInfo("Failed to get connection!", e);
            return null;
        }
    }

    public Connection getConnection() {
        return this.getConnection(new Date());
    }

    public void setUsable() {
        this.usable = true;
    }

    public void setUnusable() {
        this.usable = false;
    }

    public String getPrettyName() {
        return this.getIdentifier();
    }

    public void shutdown() {
        this.awaitShutdown(DBOperator::threadedShutdown).join().accept(this);
    }

    public void forceCommit() {
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            connection.commit();
        }
        catch (Exception e) {
            this.getPluginUser().logSevereWithInfo("Failed to close connection!", e);
        }
    }

    public static void threadedShutdown(DBOperator operator) {
        if (!operator.isUsable()) {
            return;
        }
        operator.getPluginUser().logInfo("Shutting down database connection (" + operator.getPrettyName() + ")...");
        if (operator.getDataSource() != null) {
            operator.forceCommit();
            operator.getDataSource().close();
            operator.setDataSource(null);
        }
        operator.unregister();
        operator.setUnusable();
        operator.getPluginUser().logInfo("Database connection (" + operator.getPrettyName() + ") has been shut down.");
    }

    public boolean isPastCooldown() {
        if (this.lastConnection == null) {
            return true;
        }
        return new Date().getTime() - this.lastConnection.getTime() >= 2000L;
    }

    public CompletableFuture<Consumer<DBOperator>> awaitShutdown(Consumer<DBOperator> whenDone) {
        return CompletableFuture.supplyAsync(() -> {
            while (!this.isPastCooldown()) {
                Thread.onSpinWait();
            }
            return whenDone;
        });
    }

    public void addAlter(String version, String statement) {
        this.alterMap.put(version, statement);
    }

    public void removeAlter(String version) {
        this.alterMap.remove(version);
    }

    public DatabaseType getType() {
        return this.connectorSet.getType();
    }

    public ExecutionResult executeSingle(String statement, Consumer<PreparedStatement> statementBuilder, boolean ignoreErrors) {
        AtomicReference<ExecutionResult> result;
        block4: {
            result = new AtomicReference<ExecutionResult>(ExecutionResult.ERROR);
            try {
                Date qStart = new Date();
                Connection connection = this.getConnection(qStart);
                PreparedStatement stmt = connection.prepareStatement(statement);
                statementBuilder.accept(stmt);
                if (stmt.execute()) {
                    result.set(ExecutionResult.YES);
                } else {
                    result.set(ExecutionResult.NO);
                }
            }
            catch (Exception e) {
                if (ignoreErrors) break block4;
                this.getPluginUser().logSevereWithInfo("Failed to execute statement: " + statement, e);
            }
        }
        return result.get();
    }

    public List<ExecutionResult> execute(String statement, Consumer<PreparedStatement> statementBuilder) {
        return this.execute(statement, statementBuilder, false);
    }

    public List<ExecutionResult> execute(String statement, Consumer<PreparedStatement> statementBuilder, boolean ignoreErrors) {
        String[] statements;
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        for (String s2 : statements = statement.split(";;")) {
            if (s2 == null || s2.isEmpty() || s2.isBlank()) continue;
            Object fs = s2;
            if (!((String)fs).endsWith(";")) {
                fs = (String)fs + ";";
            }
            results.add(this.executeSingle((String)fs, statementBuilder, ignoreErrors));
        }
        return results;
    }

    public void executeQuery(String statement, Consumer<PreparedStatement> statementBuilder, DBAction action) {
        this.executeQuery(statement, statementBuilder, action, false);
    }

    public void executeQuery(String statement, Consumer<PreparedStatement> statementBuilder, DBAction action, boolean ignoreErrors) {
        block2: {
            try {
                Date qStart = new Date();
                Connection connection = this.getConnection(qStart);
                PreparedStatement stmt = connection.prepareStatement(statement);
                statementBuilder.accept(stmt);
                ResultSet set = stmt.executeQuery();
                action.accept(set);
            }
            catch (Exception e) {
                if (ignoreErrors) break block2;
                this.getPluginUser().logSevereWithInfo("Failed to execute query: " + statement, e);
            }
        }
    }

    public void createSqliteFileIfNotExists() {
        if (this.connectorSet.getType() != DatabaseType.SQLITE) {
            return;
        }
        File file = new File(this.getDatabaseFolder(), this.connectorSet.getSqliteFileName());
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public File getDatabaseFolder() {
        return DBOperator.getDatabaseFolder(this);
    }

    public void ensureFile() {
        if (this.getConnectorSet().getType() != DatabaseType.SQLITE) {
            return;
        }
        String s1 = this.getConnectorSet().getSqliteFileName();
        if (s1 == null) {
            return;
        }
        if (s1.isBlank() || s1.isEmpty()) {
            return;
        }
        this.createSqliteFileIfNotExists();
    }

    public abstract void ensureTables();

    public abstract void ensureDatabase();

    public void alterTables() {
        this.getAlterMap().forEach((version, statement) -> {
            if (version == null || version.isEmpty() || version.isBlank()) {
                return;
            }
            if (statement == null || statement.isEmpty() || statement.isBlank()) {
                return;
            }
            this.execute((String)statement, stmt -> {}, true);
        });
    }

    public void ensureUsable() {
        this.ensureFile();
        this.ensureDatabase();
        this.ensureTables();
        this.alterTables();
    }

    @Override
    public int compareTo(@NotNull DBOperator o) {
        return Long.compare(this.id, o.id);
    }

    public static File getDatabaseFolder(DBOperator operator) {
        File folder = new File(operator.getPluginUser().getDataFolder(), "storage");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public static File getMainDatabaseFolder() {
        File folder = new File(BaseManager.getBaseInstance().getDataFolder(), "storage");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public long getId() {
        return this.id;
    }

    public ConnectorSet getConnectorSet() {
        return this.connectorSet;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public BetterPlugin getPluginUser() {
        return this.pluginUser;
    }

    public Connection getRawConnection() {
        return this.rawConnection;
    }

    public ConcurrentSkipListMap<String, String> getAlterMap() {
        return this.alterMap;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public Date getLastConnection() {
        return this.lastConnection;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setConnectorSet(ConnectorSet connectorSet) {
        this.connectorSet = connectorSet;
    }

    public void setDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setPluginUser(BetterPlugin pluginUser) {
        this.pluginUser = pluginUser;
    }

    public void setRawConnection(Connection rawConnection) {
        this.rawConnection = rawConnection;
    }

    public void setAlterMap(ConcurrentSkipListMap<String, String> alterMap) {
        this.alterMap = alterMap;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public void setLastConnection(Date lastConnection) {
        this.lastConnection = lastConnection;
    }
}

