/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.lib.re2j.Pattern;
import gg.drak.thebase.utils.MatcherUtils;
import java.awt.Color;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static String newlined(String message) {
        return message.replace("%newline%", "\n");
    }

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)ColorUtils.newlined(message));
    }

    public static String colorizeHard(String message) {
        String colored = ColorUtils.colorize(message);
        List<String> regexes = List.of("([&][#]([A-Fa-f0-9]{6}))", "([{][#]([A-Fa-f0-9]{6})[}])", "([#]([A-Fa-f0-9]{6}))", "([<][#]([A-Fa-f0-9]{6})[>])");
        for (String hexRegex : regexes) {
            colored = ColorUtils.replaceHex(colored, hexRegex);
        }
        return colored;
    }

    public static String replaceHex(String message, String hexRegex) {
        Matcher matcher = MatcherUtils.matcherBuilder(hexRegex, message);
        List<String[]> groups = MatcherUtils.getGroups(matcher, 2);
        for (String[] group : groups) {
            String hex = group[1];
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g2 = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            net.md_5.bungee.api.ChatColor color = net.md_5.bungee.api.ChatColor.of((Color)new Color(r, g2, b));
            message = message.replace(group[0], color.toString());
        }
        return message;
    }

    public static BaseComponent[] color(String message) {
        return ColorUtils.colorWithEvents(message, null, null);
    }

    public static BaseComponent[] colorWithClickable(String message, @Nullable ClickEvent clickEvent) {
        return ColorUtils.colorWithEvents(message, clickEvent, null);
    }

    public static BaseComponent[] colorWithHoverable(String message, @Nullable HoverEvent hoverEvent) {
        return ColorUtils.colorWithEvents(message, null, hoverEvent);
    }

    public static BaseComponent[] colorWithEvents(String message, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent) {
        if (message == null) {
            return new ComponentBuilder().create();
        }
        if (message.contains("\n")) {
            String[] lines = message.split("\n");
            ComponentBuilder builder = new ComponentBuilder();
            int i2 = 0;
            for (String line : lines) {
                boolean isLast = i2 == lines.length - 1;
                ++i2;
                builder.append(ColorUtils.colorWithEvents(line, clickEvent, hoverEvent));
                if (isLast) continue;
                builder.append("\n");
            }
            return builder.create();
        }
        message = ColorUtils.colorize(message);
        ComponentBuilder builder = new ComponentBuilder();
        Matcher matcher = Pattern.compile("(&#([A-Fa-f0-9]{6}))").matcher(message);
        int lastEnd = 0;
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > lastEnd) {
                builder.append((BaseComponent)new TextComponent(message.substring(lastEnd, start)));
            }
            String hex = matcher.group(2);
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g2 = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            TextComponent coloredText = new TextComponent(message.substring(end));
            coloredText.setColor(net.md_5.bungee.api.ChatColor.of((Color)new Color(r, g2, b)));
            if (clickEvent != null) {
                coloredText.setClickEvent(clickEvent);
            }
            if (hoverEvent != null) {
                coloredText.setHoverEvent(hoverEvent);
            }
            lastEnd = end;
            builder.append((BaseComponent)coloredText);
        }
        if (lastEnd < message.length()) {
            TextComponent component = new TextComponent(message.substring(lastEnd));
            if (clickEvent != null) {
                component.setClickEvent(clickEvent);
            }
            if (hoverEvent != null) {
                component.setHoverEvent(hoverEvent);
            }
            builder.append((BaseComponent)component);
        }
        return builder.create();
    }

    public static String colorAsString(String message) {
        StringBuilder builder = new StringBuilder();
        for (BaseComponent component : ColorUtils.color(message)) {
            builder.append(component.toLegacyText());
        }
        return builder.toString();
    }

    public static String simpleColorBoolean(boolean bool) {
        return bool ? "&aYes" : "&cNo";
    }

    public static String stripFormatting(String from) {
        return from != null ? from.replaceAll("(?i)\u00a7[0-9A-FK-OR]", "").replaceAll("(?i)&[0-9A-FK-OR]", "") : "";
    }
}

