/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.BetterPlugin;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.sql.DBOperator;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;

public class DatabaseUtils {
    private static ConcurrentSkipListMap<BetterPlugin, ConcurrentSkipListSet<DBOperator>> dbOperators = new ConcurrentSkipListMap();

    public static void put(BetterPlugin plugin, DBOperator operator) {
        ConcurrentSkipListSet<DBOperator> operators = DatabaseUtils.get(plugin);
        operators.add(operator);
        dbOperators.put(plugin, operators);
        BukkitOfUtils.getInstance().logInfo("Loaded a Database Operator for '" + plugin.getIdentifier() + "' with ID '" + operator.getId() + "'.");
    }

    public static void remove(String identifier, long id) {
        DatabaseUtils.getPlugin(identifier).ifPresent(plugin -> {
            ConcurrentSkipListSet<DBOperator> operators = DatabaseUtils.get(plugin);
            operators.removeIf(operator -> operator.getId() == id);
            dbOperators.put((BetterPlugin)plugin, operators);
        });
    }

    public static void remove(BetterPlugin plugin, long id) {
        DatabaseUtils.remove(plugin.getIdentifier(), id);
    }

    public static void remove(String identifier, DBOperator operator) {
        DatabaseUtils.remove(identifier, operator.getId());
    }

    public static void remove(BetterPlugin plugin, DBOperator operator) {
        DatabaseUtils.remove(plugin, operator.getId());
    }

    public static ConcurrentSkipListSet<DBOperator> get(String identifier) {
        ConcurrentSkipListSet<DBOperator> operators = new ConcurrentSkipListSet<DBOperator>();
        DatabaseUtils.getPlugin(identifier).ifPresent(plugin -> {
            ConcurrentSkipListSet<DBOperator> pluginOperators = dbOperators.get(plugin);
            if (pluginOperators != null) {
                operators.addAll(pluginOperators);
            }
        });
        return operators;
    }

    public static int count(String identifier) {
        return DatabaseUtils.get(identifier).size();
    }

    public static boolean hasAny(String identifier) {
        return DatabaseUtils.count(identifier) > 0;
    }

    public static ConcurrentSkipListSet<DBOperator> get(BetterPlugin plugin) {
        return DatabaseUtils.get(plugin.getIdentifier());
    }

    public static Optional<BetterPlugin> getPlugin(String identifier) {
        AtomicReference<Object> found = new AtomicReference<Object>(null);
        dbOperators.forEach((plugin, operators) -> {
            if (found.get() != null) {
                return;
            }
            if (plugin.getIdentifier().equals(identifier)) {
                found.set(plugin);
            }
        });
        return Optional.ofNullable(found.get());
    }

    public static void clear(String identifier) {
        DatabaseUtils.getPlugin(identifier).ifPresent(dbOperators::remove);
    }

    public static void clear(BetterPlugin plugin) {
        DatabaseUtils.clear(plugin.getIdentifier());
    }

    public static boolean has(String identifier, long id) {
        return DatabaseUtils.get(identifier).stream().anyMatch(operator -> operator.getId() == id);
    }

    public static boolean has(BetterPlugin plugin, long id) {
        return DatabaseUtils.has(plugin.getIdentifier(), id);
    }

    public static boolean has(String identifier, DBOperator operator) {
        return DatabaseUtils.has(identifier, operator.getId());
    }

    public static boolean has(BetterPlugin plugin, DBOperator operator) {
        return DatabaseUtils.has(plugin.getIdentifier(), operator.getId());
    }

    public static long getNextId(String identifier) {
        return DatabaseUtils.get(identifier).isEmpty() ? 0L : DatabaseUtils.get(identifier).last().getId() + 1L;
    }

    public static long getNextId(BetterPlugin plugin) {
        return DatabaseUtils.getNextId(plugin.getIdentifier());
    }

    public static void flush(String identifier) {
        DatabaseUtils.get(identifier).forEach(DBOperator::shutdown);
    }

    public static void flush(BetterPlugin plugin) {
        DatabaseUtils.flush(plugin.getIdentifier());
    }
}

