/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.libs.caffeine.cache.Cache;
import host.plas.bou.libs.caffeine.cache.Caffeine;
import host.plas.bou.scheduling.BaseRunnable;
import host.plas.bou.scheduling.TaskManager;
import host.plas.bou.utils.ClassHelper;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class EntityUtils {
    private static Cache<String, WeakReference<Entity>> cachedEntities = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).build();
    private static EntityLookupTimer lookupTimer;

    public static void init() {
        lookupTimer = new EntityLookupTimer();
    }

    public static boolean containsValue(Entity entity) {
        return cachedEntities.asMap().containsValue(entity);
    }

    public static boolean containsKey(String uniqueId) {
        return cachedEntities.asMap().containsKey(uniqueId);
    }

    public static void cacheEntityAlreadyInSync(WeakReference<Entity> entity) {
        if (entity == null || entity.get() == null) {
            return;
        }
        if (!((Entity)entity.get()).isValid()) {
            return;
        }
        if (EntityUtils.containsKey(((Entity)entity.get()).getUniqueId().toString())) {
            return;
        }
        cachedEntities.put(((Entity)entity.get()).getUniqueId().toString(), entity);
    }

    public static void cacheEntity(WeakReference<Entity> entity, boolean isInSync) {
        if (isInSync || !ClassHelper.isFolia()) {
            EntityUtils.cacheEntityAlreadyInSync(entity);
        } else {
            TaskManager.getScheduler().runTask((Entity)entity.get(), () -> EntityUtils.cacheEntityAlreadyInSync(entity));
        }
    }

    public static void cacheEntity(WeakReference<Entity> entity) {
        EntityUtils.cacheEntity(entity, false);
    }

    public static void tickCache() {
        EntityUtils.clearCache();
        EntityUtils.collectEntities();
    }

    public static int totalEntities(World world) {
        return world.getEntities().size();
    }

    public static int totalEntities() {
        int total = 0;
        for (World world : Bukkit.getWorlds()) {
            total += EntityUtils.totalEntities(world);
        }
        return total;
    }

    public static void clearCache() {
        cachedEntities.invalidateAll();
    }

    public static void collectEntities() {
        try {
            if (ClassHelper.isFolia()) {
                for (World world : Bukkit.getWorlds()) {
                    for (Chunk chunk : world.getLoadedChunks()) {
                        TaskManager.runTask(chunk, () -> Arrays.stream(chunk.getEntities()).forEach(entity -> EntityUtils.cacheEntity(new WeakReference<Entity>((Entity)entity))));
                    }
                }
            } else {
                TaskManager.runTask(() -> EntityUtils.getEntitiesBukkit().values().forEach(EntityUtils::cacheEntity));
            }
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("An error occurred while polling entities.", e);
        }
    }

    public static ConcurrentSkipListMap<String, WeakReference<Entity>> getEntitiesBukkit() {
        ConcurrentSkipListMap<String, WeakReference<Entity>> entities = new ConcurrentSkipListMap<String, WeakReference<Entity>>();
        try {
            Bukkit.getWorlds().forEach(world -> world.getEntities().forEach(entity -> entities.put(entity.getUniqueId().toString(), new WeakReference<Entity>((Entity)entity))));
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarning("An error occurred while polling entities.", e);
        }
        return entities;
    }

    public static ConcurrentSkipListMap<String, WeakReference<Entity>> getEntities(boolean isInSync) {
        ConcurrentSkipListMap<String, WeakReference<Entity>> entities = new ConcurrentSkipListMap<String, WeakReference<Entity>>();
        if (ClassHelper.isFolia()) {
            entities.putAll(EntityUtils.getCachedEntities().asMap());
        } else if (isInSync) {
            entities.putAll(EntityUtils.getEntitiesBukkit());
        } else {
            entities.putAll(EntityUtils.getCachedEntities().asMap());
        }
        return entities;
    }

    public static ConcurrentSkipListMap<String, WeakReference<Entity>> getEntities() {
        return EntityUtils.getEntities(false);
    }

    public static void collectEntitiesThenDo(Consumer<Entity> consumer) {
        TaskManager.runTask(() -> EntityUtils.getEntities(true).forEach((s2, entity) -> TaskManager.runTask((Entity)entity.get(), () -> consumer.accept((Entity)entity.get()))));
    }

    public static void collectEntitiesThenDoSet(Consumer<Collection<Entity>> consumer) {
        TaskManager.runTask(() -> consumer.accept(EntityUtils.getEntities(true).values().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public static void collectLivingEntitiesThenDo(Consumer<LivingEntity> consumer) {
        TaskManager.runTask(() -> EntityUtils.getEntities(true).forEach((s2, entity) -> TaskManager.runTask((Entity)entity.get(), () -> {
            if (entity instanceof LivingEntity) {
                consumer.accept((LivingEntity)entity);
            }
        })));
    }

    public static ConcurrentSkipListSet<String> getOnlinePlayerNames() {
        ConcurrentSkipListSet<String> names = new ConcurrentSkipListSet<String>();
        Bukkit.getOnlinePlayers().forEach(player -> names.add(player.getName()));
        return names;
    }

    public static ConcurrentSkipListSet<String> getOnlinePlayerUuids() {
        ConcurrentSkipListSet<String> uuids = new ConcurrentSkipListSet<String>();
        Bukkit.getOnlinePlayers().forEach(player -> uuids.add(player.getUniqueId().toString()));
        return uuids;
    }

    public static Optional<Player> getLastDamager(Entity entity) {
        try {
            EntityDamageByEntityEvent lastDamageCause = (EntityDamageByEntityEvent)entity.getLastDamageCause();
            if (lastDamageCause == null) {
                return Optional.empty();
            }
            return EntityUtils.abstractDamager(lastDamageCause.getDamager());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static Optional<Player> abstractDamager(Entity damager) {
        Player attacker = null;
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            if (projectile.getShooter() instanceof Player) {
                attacker = (Player)projectile.getShooter();
            }
        } else {
            if (!(damager instanceof Player)) {
                return Optional.empty();
            }
            attacker = (Player)damager;
        }
        return Optional.ofNullable(attacker);
    }

    public static OfflinePlayer getDummyOfflinePlayer() {
        return Bukkit.getOfflinePlayer((String)"Drakified");
    }

    public static Cache<String, WeakReference<Entity>> getCachedEntities() {
        return cachedEntities;
    }

    public static void setCachedEntities(Cache<String, WeakReference<Entity>> cachedEntities) {
        EntityUtils.cachedEntities = cachedEntities;
    }

    public static EntityLookupTimer getLookupTimer() {
        return lookupTimer;
    }

    public static void setLookupTimer(EntityLookupTimer lookupTimer) {
        EntityUtils.lookupTimer = lookupTimer;
    }

    public static class EntityLookupTimer
    extends BaseRunnable {
        public EntityLookupTimer() {
            super(0L, BaseManager.getBaseConfig().getEntityCollectionFrequency());
        }

        @Override
        public void run() {
            try {
                if (this.isCancelled()) {
                    return;
                }
                EntityUtils.tickCache();
                if (this.getPeriod() != BaseManager.getBaseConfig().getEntityCollectionFrequency()) {
                    this.setPeriod(BaseManager.getBaseConfig().getEntityCollectionFrequency());
                }
            }
            catch (Exception e) {
                BukkitOfUtils.getInstance().logWarning("An error occurred while ticking the entity cache.", e);
            }
        }
    }
}

