/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.utils.MatcherUtils;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.scheduling.TaskManager;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class LocationUtils {
    public static Optional<Location> fromString(String location, boolean withYawPitch) {
        try {
            int groupCount;
            String regex;
            if (withYawPitch) {
                regex = "([a-zA-Z0-9_]+),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*)";
                groupCount = 6;
            } else {
                regex = "([a-zA-Z0-9_]+),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*)";
                groupCount = 4;
            }
            Matcher matcher = MatcherUtils.matcherBuilder(regex, location);
            List<String[]> groups = MatcherUtils.getGroups(matcher, groupCount);
            if (groups.isEmpty()) {
                return Optional.empty();
            }
            Iterator<String[]> iterator = groups.iterator();
            if (iterator.hasNext()) {
                String[] group = iterator.next();
                String world = group[0];
                double x = Double.parseDouble(group[1]);
                double y = Double.parseDouble(group[2]);
                double z = Double.parseDouble(group[3]);
                World bukkitWorld = Bukkit.getWorld((String)world);
                if (bukkitWorld == null) {
                    return Optional.empty();
                }
                if (withYawPitch && group.length == 6) {
                    float yaw = Float.parseFloat(group[4]);
                    float pitch = Float.parseFloat(group[5]);
                    return Optional.of(new Location(bukkitWorld, x, y, z, yaw, pitch));
                }
                return Optional.of(new Location(bukkitWorld, x, y, z));
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to parse location: " + location, e);
            return Optional.empty();
        }
    }

    public static Optional<Location> fromString(String location) {
        return LocationUtils.fromString(location, false);
    }

    public static String toString(Location location, boolean withYawPitch) {
        if (location == null) {
            return "world,0,0,0";
        }
        if (location.getWorld() == null) {
            return "world,0,0,0";
        }
        if (withYawPitch) {
            return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getYaw() + "," + location.getPitch();
        }
        return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }

    public static String toString(Location location) {
        return LocationUtils.toString(location, false);
    }

    public static Location getCenteredLocation(Location location) {
        return new Location(location.getWorld(), (double)location.getBlockX() + 0.5, (double)location.getBlockY(), (double)location.getBlockZ() + 0.5);
    }

    public static Location getTopLocation(Location location) {
        return LocationUtils.getTopLocation(location, true);
    }

    public static Location getTopLocation(Location location, boolean downThenUp) {
        Location top = location.clone();
        if (downThenUp) {
            top = LocationUtils.searchForTopBlock(location, BlockFace.DOWN, true, false);
            if (top == null) {
                top = LocationUtils.searchForTopBlock(location, BlockFace.UP);
            }
        } else {
            top = LocationUtils.searchForTopBlock(location, BlockFace.UP);
        }
        if (top == null) {
            top = LocationUtils.getHighestNonAirBlock(location);
            top.add(0.0, 1.0, 0.0);
        }
        return LocationUtils.getCenteredLocation(top);
    }

    public static Location searchForTopBlock(Location location, BlockFace direction) {
        return LocationUtils.searchForTopBlock(location, direction, false, false);
    }

    public static Location searchForTopBlock(Location location, BlockFace direction, boolean centered) {
        return LocationUtils.searchForTopBlock(location, direction, false, centered);
    }

    private static boolean isAirLike(Location location) {
        return LocationUtils.isAirLike(location.getBlock());
    }

    private static boolean isAirLike(Block block) {
        return block.getType() == Material.AIR || block.isPassable() && !block.getType().isSolid();
    }

    public static Location searchForTopBlock(Location location, BlockFace direction, boolean stopAtNonAir, boolean centered) {
        Location top = location.clone();
        Block block = top.getBlock();
        World world = top.getWorld();
        if (world == null) {
            return null;
        }
        while (!(LocationUtils.checkForTopableBlock(block) || block.getY() < world.getMinHeight() && block.getY() > world.getMaxHeight())) {
            if (stopAtNonAir && block.getType() != Material.AIR) {
                block = block.getRelative(direction.getOppositeFace());
                break;
            }
            block = top.getBlock().getRelative(direction);
            top = block.getLocation();
        }
        if (block.getY() < world.getMinHeight()) {
            return null;
        }
        if (block.getY() > world.getMaxHeight()) {
            return null;
        }
        if (centered) {
            return LocationUtils.getCenteredLocation(top);
        }
        return top;
    }

    public static Location getTopMostTopLocation(Location location) {
        return LocationUtils.getTopMostTopLocation(location, true);
    }

    public static Location getTopMostTopLocation(Location location, boolean centered) {
        return LocationUtils.getCenteredLocation(LocationUtils.getTopMostTopBlock(location).getLocation());
    }

    public static Block getTopMostTopBlock(Location location) {
        if (location == null) {
            return null;
        }
        if (location.getWorld() == null) {
            return null;
        }
        World world = location.getWorld();
        Block block = world.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
        Location top = block.getLocation();
        Location loc = LocationUtils.searchForTopBlock(top, BlockFace.DOWN, true, false);
        if (loc != null) {
            return loc.getBlock();
        }
        return block;
    }

    public static boolean checkForTopableBlock(Location location) {
        return LocationUtils.checkForTopableBlock(location.getBlock());
    }

    public static boolean checkForTopableBlock(Block block) {
        return LocationUtils.isAirLike(block) && LocationUtils.isAirLike(block.getRelative(BlockFace.UP));
    }

    public static Location getHighestNonAirBlock(Location location) {
        if (location == null) {
            return null;
        }
        if (location.getWorld() == null) {
            return null;
        }
        return new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ()), (double)location.getBlockZ());
    }

    public static void teleport(Entity entity, Location location) {
        TaskManager.teleport(entity, location);
    }

    public static Vector getRandomDirection(boolean normalize, double multiplier) {
        Random RNG = new Random();
        double x = RNG.nextDouble();
        double y = RNG.nextDouble();
        double z = RNG.nextDouble();
        Vector direction = new Vector(x, y, z);
        if (normalize) {
            direction = direction.normalize();
        }
        if (multiplier != 1.0) {
            direction = direction.multiply(multiplier);
        }
        return direction;
    }

    public static Vector getRandomDirection(double multiplier) {
        return LocationUtils.getRandomDirection(false, multiplier);
    }

    public static Vector getRandomDirection(boolean normalize) {
        return LocationUtils.getRandomDirection(normalize, 1.0);
    }

    public static Vector getRandomDirection() {
        return LocationUtils.getRandomDirection(1.0);
    }

    public static ConcurrentSkipListMap<Integer, Item> dropItemsWithDirection(Location location, ConcurrentSkipListMap<Integer, ItemStack> items, Vector direction) {
        ConcurrentSkipListMap<Integer, Item> dropped = new ConcurrentSkipListMap<Integer, Item>();
        if (items == null || items.isEmpty()) {
            return dropped;
        }
        if (location == null) {
            return dropped;
        }
        if (location.getWorld() == null) {
            return dropped;
        }
        items.forEach((index, item) -> {
            Item i2 = location.getWorld().dropItem(location, item);
            i2.setVelocity(direction);
            dropped.put(dropped.size(), i2);
        });
        return dropped;
    }

    public static ConcurrentSkipListMap<Integer, Item> dropItems(Location location, ConcurrentSkipListMap<Integer, ItemStack> items, boolean normalize, double multiplier) {
        return LocationUtils.dropItemsWithDirection(location, items, LocationUtils.getRandomDirection(normalize, multiplier));
    }

    public static ConcurrentSkipListMap<Integer, Item> dropItems(Location location, ConcurrentSkipListMap<Integer, ItemStack> items, double multiplier) {
        return LocationUtils.dropItemsWithDirection(location, items, LocationUtils.getRandomDirection(multiplier));
    }

    public static ConcurrentSkipListMap<Integer, Item> dropItems(Location location, ConcurrentSkipListMap<Integer, ItemStack> items, boolean normalize) {
        return LocationUtils.dropItemsWithDirection(location, items, LocationUtils.getRandomDirection(normalize));
    }

    public static ConcurrentSkipListMap<Integer, Item> dropItems(Location location, ConcurrentSkipListMap<Integer, ItemStack> items) {
        return LocationUtils.dropItemsWithDirection(location, items, LocationUtils.getRandomDirection());
    }
}

