/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.BetterPlugin;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.notifications.NotificationTimer;
import java.util.Arrays;
import java.util.Locale;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public class MessageUtils {
    public static String getNotificationIdentifier(String message) {
        return MessageUtils.truncateString(message, 50);
    }

    public static String truncateString(String string, int length) {
        if (string == null) {
            return "null";
        }
        if (string.length() > length) {
            return string.substring(0, length);
        }
        return string;
    }

    public static void doReplaceAndSend(CommandSender to, String message, String prefix) {
        if (message == null) {
            return;
        }
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            MessageUtils.sendMessage(to, prefix + line);
        }
        NotificationTimer.addNotification(MessageUtils.getNotificationIdentifier(message), to);
    }

    public static void doReplaceAndSend(CommandSender to, String message) {
        MessageUtils.doReplaceAndSend(to, message, "");
    }

    public static void doReplaceAndSend(String message, String prefix) {
        MessageUtils.doReplaceAndSend(BaseManager.getConsole(), message, prefix);
    }

    public static void doReplaceAndSend(String message, BetterPlugin base, String prefix) {
        MessageUtils.doReplaceAndSend(message, base.getLogPrefix() + prefix);
    }

    @Deprecated
    public static void logInfo(String message) {
        MessageUtils.logInfo(message, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logWarning(String message) {
        MessageUtils.logWarning(message, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logSevere(String message) {
        MessageUtils.logSevere(message, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logDebug(String message) {
        MessageUtils.logDebug(message, (BetterPlugin)BaseManager.getBaseInstance());
    }

    public static void logInfo(String message, BetterPlugin base) {
        if (!BaseManager.getBaseConfig().getIsInfoLoggingEnabled()) {
            return;
        }
        MessageUtils.doReplaceAndSend(message, base, BaseManager.getBaseConfig().getIsInfoLoggingPrefix());
    }

    public static void logWarning(String message, BetterPlugin base) {
        if (!BaseManager.getBaseConfig().getIsWarnLoggingEnabled()) {
            return;
        }
        MessageUtils.doReplaceAndSend(message, base, BaseManager.getBaseConfig().getIsWarnLoggingPrefix());
    }

    public static void logSevere(String message, BetterPlugin base) {
        if (!BaseManager.getBaseConfig().getIsSevereLoggingEnabled()) {
            return;
        }
        MessageUtils.doReplaceAndSend(message, base, BaseManager.getBaseConfig().getIsSevereLoggingPrefix());
    }

    public static void logDebug(String message, BetterPlugin base) {
        if (!BaseManager.getBaseConfig().getIsDebugLoggingEnabled()) {
            return;
        }
        MessageUtils.doReplaceAndSend(message, base, BaseManager.getBaseConfig().getIsDebugLoggingPrefix());
    }

    @Deprecated
    public static void logInfo(StackTraceElement[] stackTraceElements) {
        MessageUtils.logInfo(stackTraceElements, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logWarning(StackTraceElement[] stackTraceElements) {
        MessageUtils.logWarning(stackTraceElements, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logSevere(StackTraceElement[] stackTraceElements) {
        MessageUtils.logSevere(stackTraceElements, (BetterPlugin)BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logDebug(StackTraceElement[] stackTraceElements) {
        MessageUtils.logDebug(stackTraceElements, (BetterPlugin)BaseManager.getBaseInstance());
    }

    public static void logInfo(StackTraceElement[] stackTraceElements, BetterPlugin base) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logInfo(stackTraceElement.toString(), base));
    }

    public static void logWarning(StackTraceElement[] stackTraceElements, BetterPlugin base) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logWarning(stackTraceElement.toString(), base));
    }

    public static void logSevere(StackTraceElement[] stackTraceElements, BetterPlugin base) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logSevere(stackTraceElement.toString(), base));
    }

    public static void logDebug(StackTraceElement[] stackTraceElements, BetterPlugin base) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logDebug(stackTraceElement.toString(), base));
    }

    public static void logInfo(Throwable throwable, BetterPlugin base) {
        MessageUtils.logInfo(throwable.getMessage(), base);
        MessageUtils.logInfo(throwable.getStackTrace(), base);
    }

    public static void logWarning(Throwable throwable, BetterPlugin base) {
        MessageUtils.logWarning(throwable.getMessage(), base);
        MessageUtils.logWarning(throwable.getStackTrace(), base);
    }

    public static void logSevere(Throwable throwable, BetterPlugin base) {
        MessageUtils.logSevere(throwable.getMessage(), base);
        MessageUtils.logSevere(throwable.getStackTrace(), base);
    }

    public static void logDebug(Throwable throwable, BetterPlugin base) {
        MessageUtils.logDebug(throwable.getMessage(), base);
        MessageUtils.logDebug(throwable.getStackTrace(), base);
    }

    @Deprecated
    public static void logInfo(String message, Throwable throwable) {
        MessageUtils.logInfo(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logWarning(String message, Throwable throwable) {
        MessageUtils.logWarning(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logSevere(String message, Throwable throwable) {
        MessageUtils.logSevere(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logDebug(String message, Throwable throwable) {
        MessageUtils.logDebug(message, throwable, BaseManager.getBaseInstance());
    }

    public static void logInfo(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logInfo(message, base);
        MessageUtils.logInfo(throwable.getMessage(), base);
        MessageUtils.logInfo(throwable.getStackTrace(), base);
    }

    public static void logWarning(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logWarning(message, base);
        MessageUtils.logWarning(throwable.getMessage(), base);
        MessageUtils.logWarning(throwable.getStackTrace(), base);
    }

    public static void logSevere(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logSevere(message, base);
        MessageUtils.logSevere(throwable.getMessage(), base);
        MessageUtils.logSevere(throwable.getStackTrace(), base);
    }

    public static void logDebug(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logDebug(message, base);
        MessageUtils.logDebug(throwable.getMessage(), base);
        MessageUtils.logDebug(throwable.getStackTrace(), base);
    }

    @Deprecated
    public static void logInfoWithInfo(String message, Throwable throwable) {
        MessageUtils.logInfoWithInfo(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logWarningWithInfo(String message, Throwable throwable) {
        MessageUtils.logWarningWithInfo(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logSevereWithInfo(String message, Throwable throwable) {
        MessageUtils.logSevereWithInfo(message, throwable, BaseManager.getBaseInstance());
    }

    @Deprecated
    public static void logDebugWithInfo(String message, Throwable throwable) {
        MessageUtils.logDebugWithInfo(message, throwable, BaseManager.getBaseInstance());
    }

    public static void logInfoWithInfo(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logInfo(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable, base);
    }

    public static void logWarningWithInfo(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logWarning(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable, base);
    }

    public static void logSevereWithInfo(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logSevere(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable, base);
    }

    public static void logDebugWithInfo(String message, Throwable throwable, BetterPlugin base) {
        MessageUtils.logDebug(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable, base);
    }

    public static void sendMessage(CommandSender to, String message) {
        to.sendMessage(MessageUtils.codedString(message));
    }

    public static String codedString(String text) {
        return MessageUtils.formatted(MessageUtils.newLined(ChatColor.translateAlternateColorCodes((char)'&', (String)text)));
    }

    public static String formatted(String string) {
        String[] strings = string.split(" ");
        for (int i2 = 0; i2 < strings.length; ++i2) {
            if (strings[i2].toLowerCase(Locale.ROOT).startsWith("<to_upper>")) {
                strings[i2] = strings[i2].toUpperCase(Locale.ROOT).replace("<TO_UPPER>", "");
            }
            if (!strings[i2].toLowerCase(Locale.ROOT).startsWith("<to_lower>")) continue;
            strings[i2] = strings[i2].toLowerCase(Locale.ROOT).replace("<to_lower>", "");
        }
        StringBuilder builder = new StringBuilder();
        for (int i3 = 0; i3 < strings.length; ++i3) {
            if (i3 == strings.length - 1) {
                builder.append(strings[i3]);
                continue;
            }
            builder.append(strings[i3]).append(" ");
        }
        return builder.toString();
    }

    public static String newLined(String text) {
        return text.replace("%newline%", "\n");
    }

    public static boolean isCommand(String msg) {
        return msg.startsWith("/");
    }
}

