/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import com.mojang.authlib.GameProfile;
import host.plas.bou.utils.ColorUtils;
import host.plas.bou.utils.VersionTool;
import host.plas.bou.utils.obj.Versioning;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.entity.Player;

public class PlayerUtils {
    public static void updatePlayerName(Player player, String name, boolean format, boolean tabAsWell) {
        String toSet = format ? ColorUtils.colorizeHard(name) : name;
        String noColor = ColorUtils.stripFormatting(name);
        player.setDisplayName(toSet);
        player.setCustomName(noColor);
        player.setCustomNameVisible(true);
        PlayerUtils.patchProfile(player, noColor);
        if (tabAsWell) {
            player.setPlayerListName(toSet);
        }
    }

    public static Optional<GameProfile> getProfile(Player player) {
        try {
            return Optional.ofNullable((GameProfile)VersionTool.getCraftPlayerGetGameProfileMethod().invoke((Object)player, new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static void patchProfile(Player player, String newName) {
        PlayerUtils.getProfile(player).ifPresent(profile -> {
            try {
                String cleansedName = ColorUtils.stripFormatting(newName);
                VersionTool.getGameProfileNameField().set(profile, cleansedName);
                PlayerUtils.registerName(player, cleansedName);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public static void registerName(Player player, String name) {
        try {
            String cleansedName = ColorUtils.stripFormatting(name);
            Object entityPlayer = VersionTool.getCraftPlayerGetHandleMethod().invoke((Object)player, new Object[0]);
            boolean is13R2Plus = Versioning.getServerVersion().isAfter(13L, 1L);
            String toPut = is13R2Plus ? cleansedName.toLowerCase(Locale.ENGLISH) : cleansedName;
            VersionTool.getPlayersMap().put(toPut, entityPlayer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

