/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.BetterPlugin;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginUtils {
    private static ConcurrentSkipListSet<BetterPlugin> loadedBOUPlugins = new ConcurrentSkipListSet();

    public static boolean registerPlugin(BetterPlugin plugin) {
        if (PluginUtils.isPluginRegistered(plugin.getIdentifier())) {
            PluginUtils.unregisterPlugin(plugin);
        }
        return PluginUtils.getLoadedBOUPlugins().add(plugin);
    }

    public static boolean unregisterPlugin(BetterPlugin plugin) {
        if (!PluginUtils.isPluginRegistered(plugin.getIdentifier())) {
            return false;
        }
        return PluginUtils.getLoadedBOUPlugins().removeIf(loadedPlugin -> loadedPlugin.getIdentifier().equals(plugin.getIdentifier()));
    }

    public static Optional<BetterPlugin> getPlugin(String identifier) {
        return PluginUtils.getLoadedBOUPlugins().stream().filter(plugin -> plugin.getName().equals(identifier)).findFirst();
    }

    public static boolean isPluginRegistered(String identifier) {
        return PluginUtils.getPlugin(identifier).isPresent();
    }

    public static NamespacedKey getPluginKey(BetterPlugin plugin, String key) {
        return PluginUtils.getPluginKey((JavaPlugin)plugin, key);
    }

    public static NamespacedKey getPluginKey(JavaPlugin plugin, String key) {
        return new NamespacedKey((Plugin)plugin, key);
    }

    public static int getLoadedBOUPluginCount() {
        return PluginUtils.getLoadedBOUPlugins().size();
    }

    public static ConcurrentSkipListSet<BetterPlugin> getLoadedBOUPlugins() {
        return loadedBOUPlugins;
    }

    public static void setLoadedBOUPlugins(ConcurrentSkipListSet<BetterPlugin> loadedBOUPlugins) {
        PluginUtils.loadedBOUPlugins = loadedBOUPlugins;
    }
}

