/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.commands.Sender;
import host.plas.bou.instances.BaseManager;
import host.plas.bou.utils.UuidUtils;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SenderUtils {
    public static String formatUuid(String name, boolean isConsole) {
        return isConsole ? BaseManager.getBaseConfig().getConsoleUUID() : SenderUtils.getUuidByName(name);
    }

    public static String getUuidByName(String name) {
        if (name.equals(BaseManager.getBaseConfig().getConsoleUUID())) {
            return BaseManager.getBaseConfig().getConsoleUUID();
        }
        return Bukkit.getOfflinePlayer((String)name).getUniqueId().toString();
    }

    public static String formatName(String name, boolean isConsole) {
        return isConsole ? BaseManager.getBaseConfig().getConsoleName() : name;
    }

    public static Optional<OfflinePlayer> getOfflinePlayer(String uuid) {
        if (uuid.equals(BaseManager.getBaseConfig().getConsoleUUID())) {
            return Optional.empty();
        }
        return Optional.of(Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)));
    }

    public static boolean isConsole(String uuid) {
        try {
            return UuidUtils.toUuid(uuid).equals(BaseManager.getBaseConfig().getConsoleUUID());
        }
        catch (Throwable e) {
            return UuidUtils.toUuid(uuid).equals("%");
        }
    }

    public static Optional<CommandSender> getSender(String nameOrUuid) {
        String uuid = UuidUtils.toUuid(nameOrUuid);
        if (uuid.equals(BaseManager.getBaseConfig().getConsoleUUID())) {
            return Optional.of(SenderUtils.getConsoleSender());
        }
        return Optional.ofNullable(Bukkit.getPlayer((UUID)UUID.fromString(uuid)));
    }

    public static CommandSender getConsoleSender() {
        return Bukkit.getConsoleSender();
    }

    public static Optional<Sender> getAsSender(String nameOrUuid) {
        return SenderUtils.getSender(nameOrUuid).map(Sender::new);
    }

    public static Sender getConsoleAsSender() {
        return new Sender(SenderUtils.getConsoleSender());
    }

    public static Sender getSender(CommandSender sender) {
        return new Sender(sender);
    }

    public static Optional<Sender> getOfflineSender(OfflinePlayer player) {
        try {
            if (player instanceof Player) {
                return Optional.of(SenderUtils.getSender((CommandSender)((Player)player)));
            }
            Player p = player.getPlayer();
            if (p == null) {
                return Optional.empty();
            }
            return Optional.of(SenderUtils.getSender((CommandSender)p));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static void broadcast(String message) {
        SenderUtils.broadcast(message, true);
    }

    public static void broadcast(String message, boolean includeConsole) {
        SenderUtils.broadcast(message, includeConsole, true);
    }

    public static void broadcast(String message, boolean includeConsole, boolean format) {
        Bukkit.getOnlinePlayers().forEach(player -> SenderUtils.getSender((CommandSender)player).sendMessage(message, format));
        if (includeConsole) {
            SenderUtils.getConsoleAsSender().sendMessage(message, format);
        }
    }
}

