/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.BukkitOfUtils;
import host.plas.bou.utils.obj.CapitalizationType;

public class StringUtils {
    public static String capitalize(String input, CapitalizationType type) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        CharSequence[] words = input.split(" ");
        switch (type) {
            case LOWER_ALL: {
                return input.toLowerCase();
            }
            case LOWER_FIRST: {
                return Character.toLowerCase(input.charAt(0)) + input.substring(1);
            }
            case UPPER_ALL: {
                return input.toUpperCase();
            }
            case UPPER_FIRST: {
                return Character.toUpperCase(input.charAt(0)) + input.substring(1);
            }
            case WORD_LOWER_ALL: {
                for (int i2 = 0; i2 < words.length; ++i2) {
                    words[i2] = ((String)words[i2]).toLowerCase();
                }
                return String.join((CharSequence)" ", words);
            }
            case WORD_LOWER_FIRST: {
                for (int i3 = 0; i3 < words.length; ++i3) {
                    words[i3] = i3 == 0 ? Character.toLowerCase(((String)words[i3]).charAt(0)) + ((String)words[i3]).substring(1) : ((String)words[i3]).toLowerCase();
                }
                return String.join((CharSequence)" ", words);
            }
            case WORD_UPPER_ALL: {
                for (int i4 = 0; i4 < words.length; ++i4) {
                    words[i4] = ((String)words[i4]).toUpperCase();
                }
                return String.join((CharSequence)" ", words);
            }
            case WORD_UPPER_FIRST: {
                for (int i5 = 0; i5 < words.length; ++i5) {
                    words[i5] = i5 == 0 ? Character.toUpperCase(((String)words[i5]).charAt(0)) + ((String)words[i5]).substring(1) : ((String)words[i5]).toUpperCase();
                }
                return String.join((CharSequence)" ", words);
            }
        }
        BukkitOfUtils.getInstance().logSevere("Unknown capitalization type: " + String.valueOf((Object)type));
        return input;
    }

    public static String truncate(String input, int length) {
        if (input == null || input.length() <= length) {
            return input;
        }
        return input.substring(0, length);
    }

    public static String truncate(Object input, int length) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return StringUtils.truncate((String)input, length);
        }
        return StringUtils.truncate(input.toString(), length);
    }

    public static String truncateDecimals(String input, int length) {
        String[] parts;
        if (input == null || input.length() <= length) {
            return input;
        }
        if (input.contains(".") && (parts = input.split("\\.")).length > 1) {
            return parts[0] + "." + StringUtils.truncate(parts[1], length);
        }
        return StringUtils.truncate(input, length);
    }

    public static String truncateDecimals(Object input, int length) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return StringUtils.truncateDecimals((String)input, length);
        }
        return StringUtils.truncateDecimals(input.toString(), length);
    }

    public static String removeSpaces(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("\\s+", "");
    }

    public static String removeSpecialCharacters(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[^a-zA-Z0-9]", "");
    }
}

