/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.libs.gson.JsonElement;
import host.plas.bou.libs.gson.JsonObject;
import host.plas.bou.libs.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UUIDFetcher {
    private static final String API_URL = "https://playerdb.co/api/player/minecraft/%s";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static UUID getUUID(@NotNull String name) {
        name = name.toLowerCase();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(API_URL, name)).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            connection.setReadTimeout(5000);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                JsonElement parsed = new JsonParser().parse(response.toString());
                if (parsed == null || !parsed.isJsonObject()) {
                    UUID uUID = null;
                    return uUID;
                }
                JsonObject data = parsed.getAsJsonObject();
                UUID uUID = UUID.fromString(data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("id").getAsString());
                return uUID;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getName(@NotNull String uuid) {
        uuid = uuid.toLowerCase();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(API_URL, uuid)).openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
            connection.addRequestProperty("Pragma", "no-cache");
            connection.setReadTimeout(5000);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                JsonElement parsed = new JsonParser().parse(response.toString());
                if (parsed == null || !parsed.isJsonObject()) {
                    String string = null;
                    return string;
                }
                JsonObject data = parsed.getAsJsonObject();
                String string = data.get("data").getAsJsonObject().get("player").getAsJsonObject().get("username").getAsString();
                return string;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getName(UUID uuid) {
        return UUIDFetcher.getName(uuid.toString());
    }
}

