/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import host.plas.bou.instances.BaseManager;
import host.plas.bou.utils.UUIDFetcher;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class UuidUtils {
    public static boolean isUuid(String thing) {
        try {
            UUID.fromString(thing);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String toUuid(String name) {
        if (UuidUtils.isUuid(name)) {
            return name;
        }
        if (UuidUtils.isConsole(name)) {
            return UuidUtils.getConsoleUUID();
        }
        UUID uuid = UUIDFetcher.getUUID(name);
        if (uuid == null) {
            return null;
        }
        return uuid.toString();
    }

    public static String toName(String uuid) {
        if (UuidUtils.isUuid(uuid)) {
            return UUIDFetcher.getName(uuid);
        }
        if (UuidUtils.isConsole(uuid)) {
            return UuidUtils.getConsoleName();
        }
        return null;
    }

    public static boolean isConsole(String thing) {
        return thing.equals(UuidUtils.getConsoleName()) || thing.equals(UuidUtils.getConsoleUUID());
    }

    public static String getConsoleName() {
        return BaseManager.getBaseConfig().getConsoleName();
    }

    public static String getConsoleUUID() {
        return BaseManager.getBaseConfig().getConsoleUUID();
    }

    public static boolean isValidPlayer(OfflinePlayer player) {
        if (player == null) {
            return false;
        }
        return player.getName() != null && !player.getName().isBlank();
    }

    public static boolean isValidPlayerName(String playerName) {
        if (playerName == null) {
            return false;
        }
        if (playerName.isBlank()) {
            return false;
        }
        if (UuidUtils.isOfflineMode()) {
            return true;
        }
        try {
            return UUIDFetcher.getUUID(playerName) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isValidPlayerUUID(String uuid) {
        if (uuid == null) {
            return false;
        }
        if (uuid.isBlank()) {
            return false;
        }
        if (UuidUtils.isOfflineMode()) {
            return true;
        }
        try {
            return UUIDFetcher.getName(uuid) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isOfflineMode() {
        return !Bukkit.getOnlineMode();
    }
}

