/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils;

import com.mojang.authlib.GameProfile;
import host.plas.bou.BukkitOfUtils;
import host.plas.bou.commands.CommandHandler;
import host.plas.bou.libs.gson.Gson;
import host.plas.bou.libs.gson.GsonBuilder;
import host.plas.bou.utils.obj.Versioning;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class VersionTool {
    public static final Gson GSON = new GsonBuilder().create();
    private static Class<?> CLASS_BUKKIT_SERVER = null;
    private static Class<?> CLASS_PLAYER_LIST = null;
    private static Class<?> CLASS_CRAFT_PLAYER = null;
    private static Class<?> CLASS_CRAFT_ITEM_STACK = null;
    private static Class<?> CLASS_NBT_TAG_COMPOUND = null;
    private static Class<?> CLASS_MOJANGSON_PARSER = null;
    private static Class<?> CLASS_NMS_ITEM_STACK = null;
    private static Class<?> CLASS_FOLIA_ENTITY = null;
    private static Class<?> CLASS_FOLIA_LOCATION = null;
    private static Method METHOD_BUKKIT_SERVER_SYNC_COMMANDS = null;
    private static Method METHOD_CRAFT_PLAYER_GET_GAME_PROFILE = null;
    private static Method METHOD_CRAFT_PLAYER_GET_HANDLE = null;
    private static Method MOJANGSON_PARSER_PARSE_METHOD = null;
    private static Method NMS_ITEM_STACK_A_METHOD = null;
    private static Method CRAFT_ITEM_STACK_AS_BUKKIT_COPY_METHOD = null;
    private static Method FOLIA_ENTITY_TELEPORT_ASYNC_METHOD = null;
    private static Field FIELD_GAME_PROFILE_NAME = null;
    private static Field FIELD_PLAYER_LIST = null;
    private static Field FIELD_PLAYERS_BY_NAME = null;
    private static Map MAP_PLAYERS = null;
    private static Field FIELD_COMMAND_MAP_KNOWN_COMMANDS = null;
    private static String SERVER_VERSION = null;

    public static String getJsonStringFromBukkitItemStack(ItemStack stack) {
        if (VersionTool.getServerVersion().isEmpty()) {
            try {
                ConcurrentSkipListMap<String, Map> map = new ConcurrentSkipListMap<String, Map>(stack.serialize());
                map.entrySet().removeIf(entry -> entry.getValue() == null);
                ItemMeta meta = stack.getItemMeta();
                if (meta != null) {
                    map.put("meta", meta.serialize());
                }
                return GSON.toJson(map);
            }
            catch (Throwable e) {
                BukkitOfUtils.getInstance().logWarning("Failed to serialize ItemStack to JSON: ", e);
                return "{}";
            }
        }
        try {
            Object nmsItemStack = VersionTool.getNMSItemStack(stack);
            if (nmsItemStack == null) {
                return "{}";
            }
            Class<?> nmsItemStackClass = nmsItemStack.getClass();
            Method saveMethod = nmsItemStackClass.getMethod("save", VersionTool.getNBTTagCompoundClass());
            Object nbtTagCompound = saveMethod.invoke(nmsItemStack, VersionTool.getNBTTagCompoundClass().newInstance());
            return nbtTagCompound.toString();
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to serialize ItemStack to JSON: ", e);
            return "{}";
        }
    }

    public static ItemStack getBukkitItemStackFromJsonString(String nbtJson) {
        if (VersionTool.getServerVersion().isEmpty()) {
            try {
                ItemStack stack;
                block12: {
                    ConcurrentSkipListMap map = new ConcurrentSkipListMap(GSON.fromJson(nbtJson, Map.class));
                    stack = ItemStack.deserialize(map);
                    try {
                        ConcurrentSkipListMap<String, Object> metaMap = new ConcurrentSkipListMap<String, Object>();
                        if (!map.containsKey("meta")) break block12;
                        metaMap = new ConcurrentSkipListMap((Map)map.get("meta"));
                        try {
                            ItemMeta meta = GSON.fromJson(GSON.toJson(metaMap), ItemMeta.class);
                            stack.setItemMeta(meta);
                        }
                        catch (Throwable e) {
                            try {
                                ItemMeta meta = VersionTool.deserializeItemMetaFallback(stack, metaMap);
                                stack.setItemMeta(meta);
                            }
                            catch (Throwable e2) {
                                BukkitOfUtils.getInstance().logWarning("Failed to deserialize ItemStack meta from JSON: ", e2);
                            }
                        }
                    }
                    catch (Throwable e) {
                        BukkitOfUtils.getInstance().logWarning("Failed to deserialize ItemStack meta from JSON: ", e);
                    }
                }
                return stack;
            }
            catch (Throwable e) {
                BukkitOfUtils.getInstance().logWarning("Failed to deserialize ItemStack from JSON: ", e);
                return null;
            }
        }
        try {
            Object nbtTagCompound = VersionTool.parseNBT(nbtJson);
            if (nbtTagCompound == null) {
                return null;
            }
            Object nmsItemStack = VersionTool.getNMSItemStackFromNBT(nbtTagCompound);
            return VersionTool.getBukkitItemStack(nmsItemStack);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to deserialize ItemStack from JSON: ", e);
            return null;
        }
    }

    public static ItemMeta deserializeItemMetaFallback(ItemStack stack, Map<String, Object> metaMap) {
        ItemMeta meta;
        block14: {
            meta = Bukkit.getItemFactory().getItemMeta(stack.getType());
            try {
                if (meta == null) {
                    return null;
                }
                if (metaMap.containsKey("display-name")) {
                    List lore;
                    String displayName = (String)metaMap.get("display-name");
                    if (displayName != null) {
                        displayName = displayName.replace("\\", "");
                        meta.setDisplayName(VersionTool.squashComponents(VersionTool.deserializeJsonToText(displayName)).toLegacyText());
                    }
                    if ((lore = (List)metaMap.get("lore")) != null) {
                        ArrayList<TextComponent> loreComponents = new ArrayList<TextComponent>();
                        for (Object s2 : lore) {
                            loreComponents.add(VersionTool.squashComponents(VersionTool.deserializeJsonToText((String)s2)));
                        }
                        ArrayList<String> loreStrings = new ArrayList<String>();
                        for (TextComponent loreComponent : loreComponents) {
                            loreStrings.add(loreComponent.toLegacyText());
                        }
                        meta.setLore(loreStrings);
                    }
                }
                if (!(meta instanceof SkullMeta)) break block14;
                try {
                    Map profileMap;
                    SkullMeta skullMeta = (SkullMeta)meta;
                    Map skullOwnerMap = (Map)metaMap.get("skull-owner");
                    if (skullOwnerMap != null && (profileMap = (Map)skullOwnerMap.get("profile")) != null) {
                        String ownerId = (String)profileMap.get("id");
                        String ownerName = (String)profileMap.get("name");
                        if (ownerId != null) {
                            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(ownerId)));
                        } else if (ownerName != null) {
                            skullMeta.setOwner(ownerName);
                        }
                    }
                }
                catch (Throwable e) {
                    BukkitOfUtils.getInstance().logWarning("Failed to deserialize SkullMeta from JSON: ", e);
                }
            }
            catch (Throwable e2) {
                BukkitOfUtils.getInstance().logWarning("Failed to deserialize ItemStack meta from JSON: ", e2);
            }
        }
        return meta;
    }

    public static TextComponent squashComponents(BaseComponent[] components) {
        TextComponent textComponent = new TextComponent();
        for (BaseComponent component : components) {
            textComponent.addExtra(component);
        }
        return textComponent;
    }

    public static BaseComponent[] deserializeJsonToText(String json) {
        Map metaMap2 = GSON.fromJson(json, Map.class);
        String text = (String)metaMap2.get("text");
        String color = (String)metaMap2.get("color");
        String[] extra = (String[])metaMap2.get("extra");
        ComponentBuilder builder = new ComponentBuilder(text);
        if (color != null) {
            if (color.startsWith("#")) {
                int colorRed = Integer.parseInt(color.substring(1, 3), 16);
                int colorGreen = Integer.parseInt(color.substring(3, 5), 16);
                int colorBlue = Integer.parseInt(color.substring(5, 7), 16);
                builder.color(ChatColor.of((Color)new Color(colorRed, colorGreen, colorBlue)));
            } else {
                try {
                    builder.color(ChatColor.valueOf((String)color));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (extra != null) {
            for (String s2 : extra) {
                builder.append(VersionTool.deserializeJsonToText(s2));
            }
        }
        return builder.create();
    }

    public static void init() {
        Versioning.introspect();
        CommandHandler.init();
        VersionTool.initClasses();
        VersionTool.initMethods();
        VersionTool.initFields();
    }

    public static void initClasses() {
        try {
            VersionTool.getBukkitServerClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getPlayerListClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCraftPlayerClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCraftItemStackClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getNBTTagCompoundClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getMojangsonParserClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getNMSItemStackClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getFoliaEntityClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getFoliaLocationClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void initMethods() {
        try {
            VersionTool.getBukkitServerSyncCommandsMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCraftPlayerGetGameProfileMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCraftPlayerGetHandleMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getMojangsonParserParseMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getNMSItemStackAMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCraftItemStackAsBukkitCopyMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getFoliaEntityTeleportAsyncMethod();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void initFields() {
        try {
            VersionTool.getGameProfileNameField();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getPlayerListField();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getPlayersByNameField();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getPlayersMap();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            VersionTool.getCommandMapKnownCommandsField();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getNMSPackage() {
        return VersionTool.getNMSPackage(false);
    }

    public static String getNMSPackage(boolean withTrailingDot) {
        return "net.minecraft.server" + VersionTool.getServerVersionDotted() + (withTrailingDot ? "." : "");
    }

    public static String getCraftPackage() {
        return VersionTool.getCraftPackage(false);
    }

    public static String getCraftPackage(boolean withTrailingDot) {
        return "org.bukkit.craftbukkit" + VersionTool.getServerVersionDotted() + (withTrailingDot ? "." : "");
    }

    public static Class<?> getBukkitServerClass() {
        if (CLASS_BUKKIT_SERVER == null) {
            CLASS_BUKKIT_SERVER = Bukkit.getServer().getClass();
        }
        return CLASS_BUKKIT_SERVER;
    }

    public static Class<?> getPlayerListClass() throws Throwable {
        if (CLASS_PLAYER_LIST == null) {
            boolean is17OrOver = Versioning.getServerVersion().isAfter(16L);
            CLASS_PLAYER_LIST = Class.forName((String)(is17OrOver ? VersionTool.getNMSPackage() + ".players" : VersionTool.getNMSPackage()) + ".PlayerList");
        }
        return CLASS_PLAYER_LIST;
    }

    public static Class<?> getCraftPlayerClass() throws Throwable {
        if (CLASS_CRAFT_PLAYER == null) {
            CLASS_CRAFT_PLAYER = Class.forName(VersionTool.getCraftPackage() + ".entity.CraftPlayer");
        }
        return CLASS_CRAFT_PLAYER;
    }

    public static Class<?> getCraftItemStackClass() throws Throwable {
        if (CLASS_CRAFT_ITEM_STACK == null) {
            CLASS_CRAFT_ITEM_STACK = Class.forName(VersionTool.getCraftPackage() + ".inventory.CraftItemStack");
        }
        return CLASS_CRAFT_ITEM_STACK;
    }

    public static Object getNMSItemStack(ItemStack itemStack) throws Throwable {
        Class<?> craftItemStackClass = VersionTool.getCraftItemStackClass();
        Method asNMSCopy = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
        return asNMSCopy.invoke(null, itemStack);
    }

    public static Class<?> getNBTTagCompoundClass() throws Throwable {
        if (CLASS_NBT_TAG_COMPOUND == null) {
            CLASS_NBT_TAG_COMPOUND = Class.forName("net.minecraft.nbt.NBTTagCompound");
        }
        return CLASS_NBT_TAG_COMPOUND;
    }

    public static Class<?> getMojangsonParserClass() throws Throwable {
        if (CLASS_MOJANGSON_PARSER == null) {
            CLASS_MOJANGSON_PARSER = Class.forName("net.minecraft.nbt.MojangsonParser");
        }
        return CLASS_MOJANGSON_PARSER;
    }

    public static Class<?> getNMSItemStackClass() throws Throwable {
        if (CLASS_NMS_ITEM_STACK == null) {
            CLASS_NMS_ITEM_STACK = Class.forName("net.minecraft.world.item.ItemStack");
        }
        return CLASS_NMS_ITEM_STACK;
    }

    public static Class<?> getFoliaEntityClass() throws Throwable {
        if (CLASS_FOLIA_ENTITY == null) {
            CLASS_FOLIA_ENTITY = Class.forName("org.bukkit.entity.Entity");
        }
        return CLASS_FOLIA_ENTITY;
    }

    public static Class<?> getFoliaLocationClass() throws Throwable {
        if (CLASS_FOLIA_LOCATION == null) {
            CLASS_FOLIA_LOCATION = Class.forName("org.bukkit.Location");
        }
        return CLASS_FOLIA_LOCATION;
    }

    public static Method getBukkitServerSyncCommandsMethod() throws Throwable {
        if (METHOD_BUKKIT_SERVER_SYNC_COMMANDS == null) {
            METHOD_BUKKIT_SERVER_SYNC_COMMANDS = VersionTool.getBukkitServerClass().getDeclaredMethod("syncCommands", new Class[0]);
            METHOD_BUKKIT_SERVER_SYNC_COMMANDS.setAccessible(true);
        }
        return METHOD_BUKKIT_SERVER_SYNC_COMMANDS;
    }

    public static Method getCraftPlayerGetGameProfileMethod() throws Throwable {
        if (METHOD_CRAFT_PLAYER_GET_GAME_PROFILE == null) {
            METHOD_CRAFT_PLAYER_GET_GAME_PROFILE = VersionTool.getCraftPlayerClass().getMethod("getProfile", new Class[0]);
        }
        return METHOD_CRAFT_PLAYER_GET_GAME_PROFILE;
    }

    public static Method getCraftPlayerGetHandleMethod() throws Throwable {
        if (METHOD_CRAFT_PLAYER_GET_HANDLE == null) {
            METHOD_CRAFT_PLAYER_GET_HANDLE = VersionTool.getCraftPlayerClass().getMethod("getHandle", new Class[0]);
        }
        return METHOD_CRAFT_PLAYER_GET_HANDLE;
    }

    public static Method getMojangsonParserParseMethod() throws Throwable {
        if (MOJANGSON_PARSER_PARSE_METHOD == null) {
            MOJANGSON_PARSER_PARSE_METHOD = VersionTool.getMojangsonParserClass().getMethod("parse", String.class);
        }
        return MOJANGSON_PARSER_PARSE_METHOD;
    }

    public static Method getNMSItemStackAMethod() throws Throwable {
        if (NMS_ITEM_STACK_A_METHOD == null) {
            NMS_ITEM_STACK_A_METHOD = VersionTool.getNMSItemStackClass().getMethod("a", VersionTool.getNBTTagCompoundClass());
        }
        return NMS_ITEM_STACK_A_METHOD;
    }

    public static Method getCraftItemStackAsBukkitCopyMethod() throws Throwable {
        if (CRAFT_ITEM_STACK_AS_BUKKIT_COPY_METHOD == null) {
            CRAFT_ITEM_STACK_AS_BUKKIT_COPY_METHOD = VersionTool.getCraftItemStackClass().getMethod("asBukkitCopy", VersionTool.getNMSItemStackClass());
        }
        return CRAFT_ITEM_STACK_AS_BUKKIT_COPY_METHOD;
    }

    public static Method getFoliaEntityTeleportAsyncMethod() throws Throwable {
        if (FOLIA_ENTITY_TELEPORT_ASYNC_METHOD == null) {
            FOLIA_ENTITY_TELEPORT_ASYNC_METHOD = VersionTool.getFoliaEntityClass().getMethod("teleportAsync", VersionTool.getFoliaLocationClass());
        }
        return FOLIA_ENTITY_TELEPORT_ASYNC_METHOD;
    }

    public static Field getGameProfileNameField() throws Throwable {
        if (FIELD_GAME_PROFILE_NAME == null) {
            FIELD_GAME_PROFILE_NAME = GameProfile.class.getDeclaredField("name");
            FIELD_GAME_PROFILE_NAME.setAccessible(true);
        }
        return FIELD_GAME_PROFILE_NAME;
    }

    public static Field getPlayerListField() throws Throwable {
        if (FIELD_PLAYER_LIST == null) {
            FIELD_PLAYER_LIST = Bukkit.getServer().getClass().getDeclaredField("playerList");
            FIELD_PLAYER_LIST.setAccessible(true);
        }
        return FIELD_PLAYER_LIST;
    }

    public static Field getPlayersByNameField() throws Throwable {
        if (FIELD_PLAYERS_BY_NAME == null) {
            Object playerList = VersionTool.getPlayerListField().get(Bukkit.getServer());
            FIELD_PLAYERS_BY_NAME = VersionTool.getPlayerListClass().getDeclaredField("playersByName");
            FIELD_PLAYERS_BY_NAME.setAccessible(true);
        }
        return FIELD_PLAYERS_BY_NAME;
    }

    public static Map getPlayersMap() throws Throwable {
        if (MAP_PLAYERS == null) {
            Object playerList = VersionTool.getPlayerListField().get(Bukkit.getServer());
            MAP_PLAYERS = (Map)VersionTool.getPlayersByNameField().get(playerList);
        }
        return MAP_PLAYERS;
    }

    public static Field getCommandMapKnownCommandsField() throws Throwable {
        if (FIELD_COMMAND_MAP_KNOWN_COMMANDS == null) {
            FIELD_COMMAND_MAP_KNOWN_COMMANDS = CommandHandler.getCommandMap().getClass().getDeclaredField("knownCommands");
            FIELD_COMMAND_MAP_KNOWN_COMMANDS.setAccessible(true);
        }
        return FIELD_COMMAND_MAP_KNOWN_COMMANDS;
    }

    public static void syncCommands() {
        try {
            VersionTool.getBukkitServerSyncCommandsMethod().invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            BukkitOfUtils.getInstance().logWarningWithInfo("syncCommands method not found: ", e);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarningWithInfo("Failed to invoke syncCommands method: ", e);
        }
    }

    public static void unregisterKnownCommand(Command command) {
        try {
            Map knownCommands = (Map)VersionTool.getCommandMapKnownCommandsField().get(CommandHandler.getCommandMap());
            knownCommands.remove(command.getName());
            for (String alias : command.getAliases()) {
                knownCommands.remove(alias);
            }
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarningWithInfo("Failed to unregister command: ", e);
        }
    }

    public static Object parseNBT(String nbtJson) throws Throwable {
        return VersionTool.getMojangsonParserParseMethod().invoke(null, nbtJson);
    }

    public static Object getNMSItemStackFromNBT(Object nbtTagCompound) throws Throwable {
        return VersionTool.getNMSItemStackAMethod().invoke(null, nbtTagCompound);
    }

    public static ItemStack getBukkitItemStack(Object nmsItemStack) throws Throwable {
        return (ItemStack)VersionTool.getCraftItemStackAsBukkitCopyMethod().invoke(null, nmsItemStack);
    }

    public static void teleportAsync(Entity entity, Location location) {
        try {
            VersionTool.getFoliaEntityTeleportAsyncMethod().invoke((Object)entity, location);
        }
        catch (Throwable e) {
            BukkitOfUtils.getInstance().logWarning("Failed to teleport entity asynchronously: ", e);
        }
    }

    public static String getServerVersionDotted() {
        return VersionTool.getServerVersionDotted(true);
    }

    public static String getServerVersionDotted(boolean before) {
        if (SERVER_VERSION == null) {
            Object r = before ? "." + VersionTool.getServerVersion() : VersionTool.getServerVersion() + ".";
            if (((String)r).equals(".")) {
                r = "";
            }
            SERVER_VERSION = r;
        }
        return SERVER_VERSION;
    }

    public static String getServerVersion() {
        String r;
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        try {
            r = packageName.substring("org.bukkit.craftbukkit.".length());
            if (r.contains(".")) {
                r = r.substring(0, r.indexOf("."));
            }
            if (r.isBlank() || r.isEmpty()) {
                r = VersionTool.getNewServerVersion();
            }
        }
        catch (Throwable e) {
            r = VersionTool.getNewServerVersion();
        }
        return r;
    }

    public static String getNewServerVersion() {
        return "";
    }
}

