/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils.obj;

import host.plas.bou.instances.BaseManager;
import host.plas.bou.utils.obj.StringArgument;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ContextedString<A extends StringArgument>
implements Comparable<ContextedString<?>> {
    private Date createdAt = new Date();
    private Supplier<A> argumentCreator;
    private BiFunction<Integer, String[], A> argumentCreatorIndexed;
    private ConcurrentSkipListSet<A> args;

    public ContextedString(Supplier<A> argumentCreator, BiFunction<Integer, String[], A> argumentCreatorIndexed, String ... args) {
        this.argumentCreator = argumentCreator;
        this.argumentCreatorIndexed = argumentCreatorIndexed;
        this.args = ContextedString.getArgsFrom(argumentCreatorIndexed, args);
    }

    @Override
    public int compareTo(@NotNull ContextedString<?> o) {
        return this.createdAt.compareTo(o.getCreatedAt());
    }

    public A getArg(int index) {
        return (A)this.args.stream().filter(arg -> arg.getIndex() == index).findFirst().orElse((StringArgument)this.getArgumentCreator().get());
    }

    @Deprecated
    public String getArgString(int index) {
        return this.getStringArg(index);
    }

    public Optional<CommandSender> getSenderArg(int argIndex) {
        String playerName = this.getStringArg(argIndex);
        if (playerName == null) {
            return Optional.empty();
        }
        if (playerName.equals(BaseManager.getBaseConfig().getConsoleUUID())) {
            return Optional.of(Bukkit.getConsoleSender());
        }
        return Optional.ofNullable(Bukkit.getPlayer((String)playerName));
    }

    public String concatAfter(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() > index).map(StringArgument::getContent).reduce((a, b) -> a + " " + b).orElse("");
    }

    public String concatFrom(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() >= index).map(StringArgument::getContent).reduce((a, b) -> a + " " + b).orElse("");
    }

    public String concatBefore(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() < index).map(StringArgument::getContent).reduce((a, b) -> a + " " + b).orElse("");
    }

    public String concat(int start, int end) {
        return this.args.stream().filter(arg -> arg.getIndex() >= start && arg.getIndex() <= end).map(StringArgument::getContent).reduce((a, b) -> a + " " + b).orElse("");
    }

    public String concatExcept(int ... indexes) {
        return this.args.stream().filter(arg -> indexes.length != 0 && indexes[0] != -1 && indexes[0] != 0).map(StringArgument::getContent).reduce((a, b) -> a + " " + b).orElse("");
    }

    public A getLastArg() {
        return (A)((StringArgument)this.args.last());
    }

    public String getLastArgString() {
        return ((StringArgument)this.getLastArg()).getContent();
    }

    public Optional<Player> getPlayerArg(int argIndex) {
        return this.getSenderArg(argIndex).filter(sender -> sender instanceof Player).map(sender -> (Player)sender);
    }

    public boolean isArgUsable(int index) {
        return this.args.stream().anyMatch(arg -> arg.getIndex() == index);
    }

    public int getArgCount() {
        return this.args.size();
    }

    public String getStringArg(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() == index).findFirst().orElse((StringArgument)this.getArgumentCreator().get()).getContent();
    }

    public Optional<Integer> getIntArg(int index) {
        try {
            return Optional.of(Integer.parseInt(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Double> getDoubleArg(int index) {
        try {
            return Optional.of(Double.parseDouble(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Float> getFloatArg(int index) {
        try {
            return Optional.of(Float.valueOf(Float.parseFloat(this.getArgString(index))));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Long> getLongArg(int index) {
        try {
            return Optional.of(Long.parseLong(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Short> getShortArg(int index) {
        try {
            return Optional.of(Short.parseShort(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Byte> getByteArg(int index) {
        try {
            return Optional.of(Byte.parseByte(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Boolean> getBooleanArg(int index) {
        try {
            return Optional.of(Boolean.parseBoolean(this.getArgString(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public static <A extends StringArgument> ConcurrentSkipListSet<A> getArgsFrom(BiFunction<Integer, String[], A> argumentCreator, String ... args) {
        ConcurrentSkipListSet<StringArgument> arguments = new ConcurrentSkipListSet<StringArgument>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            arguments.add((StringArgument)argumentCreator.apply(i2, args));
        }
        return arguments;
    }

    public static <A extends StringArgument> ConcurrentSkipListSet<A> getArgsFrom(BiFunction<Integer, String[], A> argumentCreator, String string, String separator) {
        String[] args = string.split(separator);
        return ContextedString.getArgsFrom(argumentCreator, args);
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Supplier<A> getArgumentCreator() {
        return this.argumentCreator;
    }

    public BiFunction<Integer, String[], A> getArgumentCreatorIndexed() {
        return this.argumentCreatorIndexed;
    }

    public ConcurrentSkipListSet<A> getArgs() {
        return this.args;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setArgumentCreator(Supplier<A> argumentCreator) {
        this.argumentCreator = argumentCreator;
    }

    public void setArgumentCreatorIndexed(BiFunction<Integer, String[], A> argumentCreatorIndexed) {
        this.argumentCreatorIndexed = argumentCreatorIndexed;
    }

    public void setArgs(ConcurrentSkipListSet<A> args) {
        this.args = args;
    }
}

