/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils.obj;

import host.plas.bou.items.InventoryUtils;
import host.plas.bou.items.ItemUtils;
import host.plas.bou.utils.obj.Idable;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ManagedInventory
implements Idable {
    private static AtomicLong currentId = new AtomicLong(0L);
    private final long id = ManagedInventory.getNextId();
    private int maxItems;
    private ConcurrentSkipListMap<Integer, ItemStack> slots;
    private boolean ready;

    public static long getNextId() {
        return currentId.getAndIncrement();
    }

    public ManagedInventory(int maxItems) {
        this.maxItems = maxItems;
        this.slots = new ConcurrentSkipListMap();
        this.ready = false;
    }

    public int getFreeSlots() {
        return this.maxItems - this.slots.size();
    }

    public boolean isFull() {
        return this.slots.size() >= this.maxItems;
    }

    public boolean isEmpty() {
        return this.isEmpty(true);
    }

    public boolean isEmpty(boolean includeNothingItems) {
        if (this.getSlots().isEmpty()) {
            return true;
        }
        if (includeNothingItems) {
            return this.isOnlyNothingItems();
        }
        return false;
    }

    public boolean isOnlyNothingItems() {
        AtomicBoolean onlyNothing = new AtomicBoolean(true);
        this.getSlots().forEach((? super K slot, ? super V item) -> {
            if (!onlyNothing.get()) {
                return;
            }
            if (!this.isNothingItem((int)slot)) {
                onlyNothing.set(false);
            }
        });
        return onlyNothing.get();
    }

    public void setItem(int slot, ItemStack item) {
        this.slots.put(slot, item);
    }

    public ItemStack getItem(int slot) {
        return this.slots.get(slot);
    }

    public void removeItem(int slot) {
        this.slots.remove(slot);
    }

    public boolean isNothingItem(int slot) {
        return ItemUtils.isNothingItem(this.getItem(slot));
    }

    public void copyFrom(Inventory inventory) {
        this.slots = InventoryUtils.getInventoryContents(inventory);
    }

    public void copyTo(Inventory inventory) {
        InventoryUtils.setInventoryContents(inventory, this.slots);
    }

    public void copyFrom(ManagedInventory inventory) {
        this.slots = new ConcurrentSkipListMap<Integer, ItemStack>((SortedMap<Integer, ItemStack>)inventory.getSlots());
    }

    public void copyTo(ManagedInventory inventory) {
        inventory.setSlots(new ConcurrentSkipListMap<Integer, ItemStack>((SortedMap<Integer, ItemStack>)this.slots));
    }

    public void trim() {
        ConcurrentSkipListMap newSlots = new ConcurrentSkipListMap();
        AtomicInteger newSlot = new AtomicInteger(0);
        this.slots.forEach((? super K slot, ? super V item) -> {
            if (ItemUtils.isNothingItem(item)) {
                return;
            }
            newSlots.put(newSlot.getAndIncrement(), item);
        });
        this.slots = newSlots;
    }

    public void clear() {
        this.slots.clear();
    }

    public void clear(boolean includeNothingItems) {
        if (includeNothingItems) {
            this.clear();
        } else {
            this.slots.forEach((? super K slot, ? super V item) -> {
                if (!ItemUtils.isNothingItem(item)) {
                    this.slots.remove(slot);
                }
            });
        }
    }

    public int getFirstAvailableSlot() {
        AtomicInteger slot = new AtomicInteger(0);
        AtomicBoolean found = new AtomicBoolean(false);
        this.getSlots().forEach((? super K s2, ? super V item) -> {
            if (found.get()) {
                return;
            }
            if (this.isNothingItem((int)s2)) {
                slot.set((int)s2);
                found.set(true);
            }
            slot.incrementAndGet();
        });
        return slot.get();
    }

    public void addItem(ItemStack stack) {
        int slot = this.getFirstAvailableSlot();
        this.setItem(slot, stack);
    }

    public void removeItem(ItemStack stack) {
        this.slots.forEach((? super K slot, ? super V item) -> {
            if (item.equals((Object)stack)) {
                this.slots.remove(slot);
            }
        });
    }

    public void removeSimilar(ItemStack stack) {
        this.slots.forEach((? super K slot, ? super V item) -> {
            if (item.isSimilar(stack)) {
                this.slots.remove(slot);
            }
        });
    }

    public void addItems(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            this.addItem(stack);
        }
    }

    public void forEachItem(Consumer<ItemStack> consumer) {
        this.slots.forEach((? super K slot, ? super V item) -> consumer.accept((ItemStack)item));
    }

    public void forEachSlot(Consumer<Integer> consumer) {
        this.slots.forEach((? super K slot, ? super V item) -> consumer.accept((Integer)slot));
    }

    public void forEachSlotItem(Consumer<Integer> slotConsumer, Consumer<ItemStack> itemConsumer) {
        this.slots.forEach((? super K slot, ? super V item) -> {
            slotConsumer.accept((Integer)slot);
            itemConsumer.accept((ItemStack)item);
        });
    }

    public void forEach(BiConsumer<Integer, ItemStack> consumer) {
        this.slots.forEach(consumer);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ManagedInventory)) {
            return false;
        }
        ManagedInventory other = (ManagedInventory)obj;
        if (other.getId() != this.getId()) {
            return false;
        }
        AtomicBoolean equal = new AtomicBoolean(true);
        this.getSlots().forEach((? super K slot, ? super V item) -> {
            if (!equal.get()) {
                return;
            }
            if (!item.equals((Object)other.getItem((int)slot))) {
                equal.set(false);
            }
        });
        return equal.get();
    }

    public int size() {
        return this.slots.size();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public ConcurrentSkipListMap<Integer, ItemStack> getSlots() {
        return this.slots;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setSlots(ConcurrentSkipListMap<Integer, ItemStack> slots) {
        this.slots = slots;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

