/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils.obj;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringArgument
implements Comparable<StringArgument> {
    private final int index;
    private String content;
    @Nullable
    private ContentType overrideType;
    private ContextType contextType;

    public StringArgument(int index, String content, @Nullable ContentType overrideType, ContextType contextType) {
        this.index = index;
        this.content = content;
        this.overrideType = overrideType;
        this.contextType = contextType;
    }

    public StringArgument(int index, String content, ContextType contextType) {
        this(index, content, null, contextType);
    }

    public StringArgument(ContextType contextType) {
        this(-1, null, ContentType.BROKEN, contextType);
    }

    public ContentType getContentType() {
        if (this.overrideType != null) {
            return this.overrideType;
        }
        if (this.content == null) {
            return ContentType.NULL_STRING;
        }
        if (this.content.isEmpty()) {
            return ContentType.EMPTY_STRING;
        }
        if (this.content.isBlank()) {
            return ContentType.EMPTY_STRING;
        }
        if (this.content.equals("")) {
            return ContentType.EMPTY_STRING;
        }
        return ContentType.USABLE_STRING;
    }

    public boolean isUsable() {
        return this.getContentType() == ContentType.USABLE_STRING;
    }

    public boolean isEmpty() {
        return this.getContentType() == ContentType.EMPTY_STRING;
    }

    public boolean isNull() {
        return this.getContentType() == ContentType.NULL_STRING;
    }

    public boolean equals(String string) {
        return Objects.equals(this.content, string);
    }

    public String getContent() {
        if (!this.isUsable()) {
            return "";
        }
        return this.content;
    }

    @Override
    public int compareTo(@NotNull StringArgument o) {
        return Integer.compare(this.index, o.index);
    }

    public int getIndex() {
        return this.index;
    }

    @Nullable
    public ContentType getOverrideType() {
        return this.overrideType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOverrideType(@Nullable ContentType overrideType) {
        this.overrideType = overrideType;
    }

    public ContextType getContextType() {
        return this.contextType;
    }

    public void setContextType(ContextType contextType) {
        this.contextType = contextType;
    }

    public static enum ContextType {
        COMMAND,
        PLACEHOLDER;

    }

    public static enum ContentType {
        USABLE_STRING,
        EMPTY_STRING,
        NULL_STRING,
        BROKEN;

    }
}

