/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.utils.obj;

import host.plas.bou.BukkitOfUtils;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class Versioning
implements Comparable<Versioning> {
    private static Versioning SERVER_VERSION = null;
    private long first;
    private long second;
    private long third;

    public Versioning(long first, long second, long third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public String toString() {
        return this.first + "." + this.second + "." + this.third;
    }

    public boolean isBefore(long minorVersion) {
        return this.second < minorVersion;
    }

    public boolean isAfter(long minorVersion) {
        return this.second > minorVersion;
    }

    public boolean isSame(long minorVersion) {
        return this.second == minorVersion;
    }

    public boolean isBefore(long minorVersion, long patchVersion) {
        if (this.second < minorVersion) {
            return true;
        }
        if (this.second > minorVersion) {
            return false;
        }
        return this.third < patchVersion;
    }

    public boolean isAfter(long minorVersion, long patchVersion) {
        if (this.second > minorVersion) {
            return true;
        }
        if (this.second < minorVersion) {
            return false;
        }
        return this.third > patchVersion;
    }

    public boolean isSame(long minorVersion, long patchVersion) {
        return this.second == minorVersion && this.third == patchVersion;
    }

    public boolean isBefore(Versioning other) {
        if (this.first < other.first) {
            return true;
        }
        if (this.first > other.first) {
            return false;
        }
        if (this.second < other.second) {
            return true;
        }
        if (this.second > other.second) {
            return false;
        }
        return this.third < other.third;
    }

    public boolean isAfter(Versioning other) {
        if (this.first > other.first) {
            return true;
        }
        if (this.first < other.first) {
            return false;
        }
        if (this.second > other.second) {
            return true;
        }
        if (this.second < other.second) {
            return false;
        }
        return this.third > other.third;
    }

    public boolean isSame(Versioning other) {
        return this.first == other.first && this.second == other.second && this.third == other.third;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Versioning)) {
            return false;
        }
        Versioning other = (Versioning)obj;
        return this.isSame(other);
    }

    @Override
    public int compareTo(@NotNull Versioning o) {
        if (this.isBefore(o)) {
            return -1;
        }
        if (this.isAfter(o)) {
            return 1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.first == 0L && this.second == 0L && this.third == 0L;
    }

    public boolean isModernErrored() {
        return this.first == -2L && this.second == 0L && this.third == 0L;
    }

    public boolean isModern() {
        if (this.isModernErrored()) {
            return true;
        }
        return this.isAfter(new Versioning(1L, 20L, 4L));
    }

    public static Versioning fromString(String version) {
        try {
            String[] parts;
            if (version.contains("-")) {
                version = version.split("-")[0];
            }
            long first = (parts = version.split("\\.")).length > 0 ? Long.parseLong(Versioning.grabOnlyNumbers(parts[0])) : 0L;
            long second = parts.length > 1 ? Long.parseLong(Versioning.grabOnlyNumbers(parts[1])) : 0L;
            long third = parts.length > 2 ? Long.parseLong(Versioning.grabOnlyNumbers(parts[2])) : 0L;
            return new Versioning(first, second, third);
        }
        catch (Exception e) {
            BukkitOfUtils.getInstance().logWarningWithInfo("Failed to parse version string: " + version, e);
            return Versioning.getEmpty();
        }
    }

    public static String grabOnlyNumbers(String from) {
        return from.replaceAll("[^0-9.]", "");
    }

    public static Versioning getEmpty() {
        return new Versioning(0L, 0L, 0L);
    }

    public static Versioning getModern() {
        return new Versioning(-2L, 0L, 0L);
    }

    public static Versioning introspect() {
        SERVER_VERSION = Versioning.parseFromBukkit();
        return SERVER_VERSION;
    }

    public static Versioning getServerVersion() {
        if (SERVER_VERSION == null) {
            return Versioning.introspect();
        }
        return SERVER_VERSION;
    }

    public static String getBukkitVersion() {
        return Bukkit.getBukkitVersion();
    }

    public static Versioning parseFromBukkit() {
        return Versioning.fromString(Versioning.getBukkitVersion());
    }

    public long getFirst() {
        return this.first;
    }

    public long getSecond() {
        return this.second;
    }

    public long getThird() {
        return this.third;
    }

    public void setFirst(long first) {
        this.first = first;
    }

    public void setSecond(long second) {
        this.second = second;
    }

    public void setThird(long third) {
        this.third = third;
    }
}

