/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mc.obliviate.inventory.GuiIcon;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.util.NMSUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ComponentIcon
implements GuiIcon {
    private static final GsonComponentSerializer SERIALIZER = GsonComponentSerializer.gson();
    private static final Field DISPLAY_NAME_FIELD;
    private static final Field LORE_FIELD;
    private final Icon icon;

    private ComponentIcon(Icon icon) {
        this.icon = icon;
    }

    public static ComponentIcon fromIcon(Icon icon) {
        return new ComponentIcon(icon);
    }

    public Icon toIcon() {
        return this.icon;
    }

    @Nonnull
    public ComponentIcon setLore(Component ... lore) {
        return this.setLore(new ArrayList<Component>(Arrays.asList(lore)));
    }

    @Nonnull
    public ComponentIcon setLore(List<Component> lore) {
        ItemMeta meta = this.icon.getItem().getItemMeta();
        if (meta == null) {
            return this;
        }
        if (NMSUtil.CAN_USE_COMPONENTS) {
            try {
                List list = lore.stream().map(SERIALIZER::serialize).collect(Collectors.toList());
                LORE_FIELD.set(meta, list);
            }
            catch (IllegalAccessException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not set lore, please report this to the plugin developer!");
            }
        }
        meta.setLore(lore.stream().map(NMSUtil.LEGACY::serialize).collect(Collectors.toList()));
        this.icon.getItem().setItemMeta(meta);
        return this;
    }

    @Nonnull
    public ComponentIcon setName(Component name) {
        ItemMeta meta = this.icon.getItem().getItemMeta();
        if (meta == null) {
            return this;
        }
        if (NMSUtil.CAN_USE_COMPONENTS) {
            try {
                DISPLAY_NAME_FIELD.set(meta, SERIALIZER.serialize(name));
            }
            catch (IllegalAccessException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not set displayName, please report this to the plugin developer!");
            }
        }
        meta.setDisplayName(NMSUtil.LEGACY.serialize(name));
        this.icon.getItem().setItemMeta(meta);
        return this;
    }

    @Nonnull
    public ComponentIcon appendLore(Component ... newLines) {
        return this.appendLore(new ArrayList<Component>(Arrays.asList(newLines)));
    }

    @Nonnull
    public ComponentIcon appendLore(List<Component> lore) {
        ItemMeta meta = this.icon.getItem().getItemMeta();
        if (meta == null) {
            return this;
        }
        if (NMSUtil.CAN_USE_COMPONENTS) {
            try {
                List loreComponents = (List)LORE_FIELD.get(meta);
                ArrayList<Component> list = loreComponents == null ? new ArrayList<Component>() : loreComponents.stream().map(SERIALIZER::deserialize).collect(Collectors.toList());
                list.addAll(lore);
                return this.setLore(list);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not append lore. Please report this to the plugin developer!");
            }
        }
        List<String> serialized = lore.stream().map(NMSUtil.LEGACY::serialize).collect(Collectors.toList());
        List<String> list = meta.getLore();
        if (list != null) {
            list.addAll(serialized);
        } else {
            list = serialized;
        }
        this.icon.setLore(list);
        return this;
    }

    @Nonnull
    public ComponentIcon insertLore(int index, Component ... newLines) {
        return this.insertLore(index, new ArrayList<Component>(Arrays.asList(newLines)));
    }

    @Nonnull
    public ComponentIcon insertLore(int index, List<Component> newLines) {
        ItemMeta meta = this.icon.getItem().getItemMeta();
        if (meta == null) {
            return this;
        }
        if (NMSUtil.CAN_USE_COMPONENTS) {
            try {
                List loreComponents = (List)LORE_FIELD.get(meta);
                ArrayList<Component> list = loreComponents == null ? new ArrayList<Component>() : loreComponents.stream().map(SERIALIZER::deserialize).collect(Collectors.toList());
                list.addAll(index, newLines);
                return this.setLore(list);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Could not append lore. Please report this to the plugin developer!");
            }
        }
        List<String> serialized = newLines.stream().map(NMSUtil.LEGACY::serialize).collect(Collectors.toList());
        List<String> list = meta.getLore();
        if (list != null) {
            list.addAll(index, serialized);
        } else {
            list = serialized;
        }
        this.icon.setLore(list);
        return this;
    }

    @Nonnull
    public ComponentIcon setDurability(short newDamage) {
        this.icon.setDurability(newDamage);
        return this;
    }

    @Nonnull
    public ComponentIcon setDurability(int newDamage) {
        this.setDurability((short)newDamage);
        return this;
    }

    @Nonnull
    public ComponentIcon setAmount(int amount) {
        this.icon.setAmount(amount);
        return this;
    }

    @Nonnull
    public ComponentIcon hideFlags(ItemFlag ... itemFlag) {
        this.icon.hideFlags(itemFlag);
        return this;
    }

    @Nonnull
    public ComponentIcon hideFlags() {
        this.icon.hideFlags();
        return this;
    }

    @Nonnull
    public ComponentIcon enchant(Enchantment enchantment) {
        this.enchant(enchantment, enchantment.getStartLevel());
        return this;
    }

    @Nonnull
    public ComponentIcon enchant(Map<Enchantment, Integer> enchantments) {
        this.icon.enchant(enchantments);
        return this;
    }

    @Nonnull
    public ComponentIcon enchant(Enchantment enchantment, int level) {
        this.icon.enchant(enchantment, level);
        return this;
    }

    @Override
    @Nonnull
    public Consumer<InventoryClickEvent> getClickAction() {
        return this.icon.getClickAction();
    }

    @Nonnull
    public ComponentIcon onClick(Consumer<InventoryClickEvent> clickAction) {
        this.icon.onClick(clickAction);
        return this;
    }

    @Override
    @Nonnull
    public Consumer<InventoryDragEvent> getDragAction() {
        return this.icon.getDragAction();
    }

    @Nonnull
    public ComponentIcon onDrag(Consumer<InventoryDragEvent> dragAction) {
        this.icon.onDrag(dragAction);
        return this;
    }

    @Override
    public ItemStack getItem() {
        return this.icon.getItem();
    }

    static {
        try {
            Class<?> metaClass = NMSUtil.getCraftBukkitClass("inventory.CraftMetaItem");
            DISPLAY_NAME_FIELD = metaClass.getDeclaredField("displayName");
            DISPLAY_NAME_FIELD.setAccessible(true);
            LORE_FIELD = metaClass.getDeclaredField("lore");
            LORE_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not initialize Icon.class, please report this to the plugin developer!");
        }
    }
}

