/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.database.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import mc.obliviate.util.database.sql.SQLDriverProvider;

public class SQLiteProvider
implements SQLDriverProvider {
    private static Connection connection = null;
    private final String filePath;

    public SQLiteProvider(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Connection getConnection() {
        return connection;
    }

    @Override
    public boolean connect() {
        connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            String URL2 = "jdbc:sqlite:" + this.filePath;
            connection = DriverManager.getConnection(URL2);
            if (connection == null) {
                throw new RuntimeException("Could not connected to SQLite database!");
            }
        }
        catch (ClassNotFoundException | RuntimeException | SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void disconnect() {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
            connection = null;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
}

